local headerno=0;

local ClassColR = {};
local ClassColG = {};
local ClassColB = {};
local Bar3ColR = {};
local Bar3ColG = {};
local Bar3ColB = {};

local HealBot_Prev_State={};
local HealBot_Unit_Button={};
local HealBot_UnitStatus={};
local HealBot_PlayerDead=false;
local HealBot_CycleChecks=1;
local HealBot_CycleMidPoint=2;
local HealBot_UnitGroup={};
local HealBot_CheckGroup=0;
local HealBot_MaxGroup=1;
local HealBot_TrackUnitNames={};
local HealBot_TrackButtons={};
local HealBot_TrackManaBar={};
local HealBot_Enabled={};
local TargetButton=nil;

HealBot_Action_HealGroup = {
  "player",
  "pet",
  "party1",
  "party2",
  "party3",
  "party4",
};

HealBot_Action_HealTarget = {
};

HealBot_Action_HealButtons = {
};

HealBot_Action_UnitButtons = {
};

function HealBot_Action_AddDebug(msg)
  HealBot_AddDebug("Action: " .. msg);
end

function HealBot_HealthColor(unit,hlth,maxhlth,tooltipcol,Member_Name,UnitDead)
  if not HealBot_HealsIn[Member_Name] then HealBot_HealsIn[Member_Name]=0; end
  
  if not tooltipcol then

    if UnitDead then
      HealBot_UnitStatus[unit]=3;
    elseif hlth>maxhlth*HealBot_Config.AlertLevel and HealBot_HealsIn[Member_Name]==0 then
      HealBot_UnitStatus[unit]=0;
    elseif hlth>(maxhlth*HealBot_Config.AlertLevel)*0.7 and HealBot_HealsIn[Member_Name]==0 then
      HealBot_UnitStatus[unit]=3;
    elseif hlth>(maxhlth*HealBot_Config.AlertLevel)*0.35 and HealBot_HealsIn[Member_Name]==0 then
      HealBot_UnitStatus[unit]=2;
    else
      HealBot_UnitStatus[unit]=1;
    end
    
    local Member_Debuff=HealBot_UnitDebuff[Member_Name];
    if Member_Debuff then
        if HealBot_UnitStatus[unit]==0 or HealBot_UnitStatus[unit]>2 then HealBot_UnitStatus[unit]=2; end
        return HealBot_Config.CDCBarColour[Member_Debuff].R,
               HealBot_Config.CDCBarColour[Member_Debuff].G,
               HealBot_Config.CDCBarColour[Member_Debuff].B,
               HealBot_Config.Barcola[HealBot_Config.Current_Skin];
    end
    local Member_Buff=HealBot_UnitBuff[Member_Name];
    if Member_Buff then
        if HealBot_UnitStatus[unit]==0 then HealBot_UnitStatus[unit]=3; end
        return HealBot_buffbarcolr[Member_Buff],
               HealBot_buffbarcolg[Member_Buff],
               HealBot_buffbarcolb[Member_Buff],
               HealBot_Config.Barcola[HealBot_Config.Current_Skin];
    end
  end

  local pct = hlth+HealBot_HealsIn[Member_Name];
  if pct<maxhlth then
    pct=pct/maxhlth;
  else
    pct=1;
  end
 
  local r,g,b = 1.0, 1.0, 0.0;
  local a=HealBot_Config.Barcola[HealBot_Config.Current_Skin];
  if pct>HealBot_Config.AlertLevel then
    a=HealBot_Config.bardisa[HealBot_Config.Current_Skin];
  end

  if pct>=0.98 then r = 0.0; end
  if pct<0.98 and pct>=0.65 then r=2.94-(pct*3); end 
  if pct<=0.64 and pct>0.31 then g=(pct-0.31)*3; end 
  if pct<=0.31 then g = 0.0; end
  return r,g,b,a;
end

function HealBot_Action_HealthBar(button)
  local name = button:GetName();
  return getglobal(name.."Bar");
end

function HealBot_Action_HealthBar2(button)
  local name = button:GetName();
  return getglobal(name.."Bar2");
end

function HealBot_Action_HealthBar3(button)
  local name = button:GetName();
  return getglobal(name.."Bar3");
end

function HealBot_AlwaysHeal()
  return HealBot_Config.EnableHealthy==1
end

function HealBot_MayHeal(unit, name)
  if name then
    if unit ~= 'target' then return true end
    if not HealBot_Config.TargetHeals or UnitCanAttack("player",unit) then return false end
    return true;
  else
    return false;
  end
end

function HealBot_ShouldHeal(unit, hlth, maxhlth, UnitDead, name)
  return HealBot_MayHeal(unit, name) and hlth>0 and not UnitDead
    and (hlth<maxhlth*HealBot_Config.AlertLevel or HealBot_AlwaysHeal());
end

function HealBot_Action_ShouldHealSome()
  return table.foreach(HealBot_Action_HealButtons, function (index,button)
    local hlth=UnitHealth(button.unit);
    local name = UnitName(button.unit);
    local maxhlth=UnitHealthMax(button.unit);
    local UnitDead = UnitIsDeadOrGhost(button.unit);
    if HealBot_UnitDebuff[name] and not UnitDead then
--      if name==HealBot_PlayerName then
        return button.unit;
--      elseif IsSpellInRange(HealBot_DebuffSpell[HealBot_UnitDebuff[name]], button.unit)==1 then
--        return button.unit;
--      end
    end
    if HealBot_UnitBuff[name] and not UnitDead then
--      if name==HealBot_PlayerName then
        return button.unit;
--      elseif IsSpellInRange(HealBot_UnitBuff[name], button.unit)==1 then
--        return button.unit;
--      end
    end
    if (HealBot_ShouldHeal(button.unit, hlth, maxhlth, UnitDead, name)) then return button.unit; end
  end);
end

function HealBot_CanHeal(unit, hlth, maxhlth, UnitDead, name)
  if (not name) then return false end;
  if not HealBot_PlayerCanCast or HealBot_PlayerDead then return false end;

  local SHeal = HealBot_ShouldHeal(unit, hlth, maxhlth, UnitDead, name)
  if SHeal then
    local spell = HealBot_GetHealSpell(unit,HealBot_Action_SpellPattern("Left"))
    if not spell then spell = HealBot_GetHealSpell(unit,HealBot_Action_SpellPattern("Middle")) end
    if not spell then spell = HealBot_GetHealSpell(unit,HealBot_Action_SpellPattern("Right")) end
    if not spell then spell = HealBot_GetHealSpell(unit,HealBot_Action_SpellPattern("Button4")) end
    if not spell then spell = HealBot_GetHealSpell(unit,HealBot_Action_SpellPattern("Button5")) end
    if not spell then
      return false
    else
      return true
    end
  end
  return false
end

function HealBot_Action_RefreshBar3(unit)
  if HealBot_Config.bar2size[HealBot_Config.Current_Skin]>0 and HealBot_Action_UnitButtons[unit] then
    table.foreach(HealBot_Action_UnitButtons[unit], function (index,button)
      HealBot_Action_SetBar3Value(button);
    end);
  end
end

function HealBot_Action_RefreshAllBar3()
    table.foreach(HealBot_Action_HealButtons, function (index,button)
      HealBot_Action_SetBar3Value(button);
    end)
end

function HealBot_Action_SetBar3Value(button)
  local unit = button.unit;
  if not unit then return; end
  local bar3 = HealBot_Action_HealthBar3(button); 
  local mana = UnitMana(unit);
  local maxmana = UnitManaMax(unit);
  bar3:SetMinMaxValues(0,maxmana);
  bar3:SetValue(mana);
end


function HealBot_Action_EnableButton(button)
  local unit = button.unit;
  local Member_Name=UnitName(unit);
  local name=Member_Name;
  if not Member_Name then return; end
  local hlth=UnitHealth(unit);
  local maxhlth=UnitHealthMax(unit);
  local UnitDead = UnitIsDeadOrGhost(unit);
  local bar = HealBot_Action_HealthBar(button);
  local bar2 = HealBot_Action_HealthBar2(button);  
  local bar3 = HealBot_Action_HealthBar3(button);   
  local sr=HealBot_Config.btextenabledcolr[HealBot_Config.Current_Skin];
  local sg=HealBot_Config.btextenabledcolg[HealBot_Config.Current_Skin];
  local sb=HealBot_Config.btextenabledcolb[HealBot_Config.Current_Skin];
  local sa=HealBot_Config.btextenabledcola[HealBot_Config.Current_Skin];
  local r,g,b,a = HealBot_HealthColor(unit,hlth,maxhlth,false,Member_Name,UnitDead)
  local textlen = floor(5+(((HealBot_Config.bwidth[HealBot_Config.Current_Skin]*1.8)/HealBot_Config.btextheight[HealBot_Config.Current_Skin])-(HealBot_Config.btextheight[HealBot_Config.Current_Skin]/2)))-2
  local bwidth = HealBot_Config.bwidth[HealBot_Config.Current_Skin] or 85;
  

  bar:SetMinMaxValues(0,maxhlth);
  bar:SetValue(hlth);
  
  if Member_Name==HealBot_PlayerName then
    if UnitDead then
      HealBot_PlayerDead=true;
    else
      HealBot_PlayerDead=false;
    end
  end

  if HealBot_HealsIn[Member_Name] then
    bar2:SetMinMaxValues(0,maxhlth);
    bar2:SetValue(hlth+HealBot_HealsIn[Member_Name]);
  else
    HealBot_HealsIn[Member_Name]=0
    bar2:SetValue(0);
  end
  bar.txt = getglobal(bar:GetName().."_text");

  local fastenable=false;
  local ProcessThis=true;
  if HealBot_Config.ProtectPvP==1 then
    if UnitIsPVP(unit) and not UnitIsPVP("player") then ProcessThis=false; end
  end
  if HealBot_PlayerCanCast and ProcessThis and not HealBot_PlayerDead and not UnitDead then
    if HealBot_UnitDebuff[Member_Name] then
      if Member_Name==HealBot_PlayerName then
        fastenable=true;
      elseif IsSpellInRange(HealBot_DebuffSpell[HealBot_UnitDebuff[Member_Name]], unit)==1 then
        fastenable=true;
      end
    elseif HealBot_UnitBuff[Member_Name] then
      if Member_Name==HealBot_PlayerName then
        fastenable=true;
      elseif IsSpellInRange(HealBot_UnitBuff[Member_Name], unit)==1 then
        fastenable=true;
      end
    end
    if not fastenable and (hlth<maxhlth*HealBot_Config.AlertLevel or HealBot_AlwaysHeal()) then
      if HealBot_CanHeal(unit, hlth, maxhlth, UnitDead, Member_Name) then
        fastenable=true;
      end
    end
  end
  
  if fastenable then
--    button:Enable();
    HealBot_Enabled[Member_Name]=true;
--    if not HealBot_IsFighting then 
 --      HealBot_Action_SetAttribs(button,"Enabled")
--    end
    bar:SetStatusBarColor(r,g,b,HealBot_Config.Barcola[HealBot_Config.Current_Skin]);
    bar2:SetStatusBarColor(r,g,b,HealBot_Config.BarcolaInHeal[HealBot_Config.Current_Skin]);
    bar3:SetStatusBarColor(Bar3ColR[Member_Name],Bar3ColG[Member_Name],Bar3ColB[Member_Name],HealBot_Config.Barcola[HealBot_Config.Current_Skin])
	if (HealBot_IsCasting and HealBot_CastingTarget==unit and hlth+HealBot_HealsIn[Member_Name]<maxhlth) or (HealBot_IsCasting and HealBot_Config.BarHealthIncHeals==0) then
      sr=HealBot_Config.btextdisbledcolr[HealBot_Config.Current_Skin];
      sg=HealBot_Config.btextdisbledcolg[HealBot_Config.Current_Skin];
      sb=HealBot_Config.btextdisbledcolb[HealBot_Config.Current_Skin];
      sa=HealBot_Config.btextdisbledcola[HealBot_Config.Current_Skin];
      if sa<0.5 then sa=0.5; end
    elseif HealBot_Config.SetClassColourText==1 then
      sr,sg,sb = ClassColR[Member_Name],ClassColG[Member_Name],ClassColB[Member_Name];
      sa = 1;
    elseif HealBot_UnitDebuff[Member_Name] then
      sr=HealBot_Config.btextcursecolr[HealBot_Config.Current_Skin];
      sg=HealBot_Config.btextcursecolg[HealBot_Config.Current_Skin];
      sb=HealBot_Config.btextcursecolb[HealBot_Config.Current_Skin];
      sa=HealBot_Config.btextcursecola[HealBot_Config.Current_Skin];
    end
    if unit==HealBot_Action_DisableTooltipUnit then
      HealBot_Action_TooltipUnit = unit;
      HealBot_Action_DisableTooltipUnit = nil;
      HealBot_Action_RefreshTooltip(unit);
    end
  else
--    button:Disable();
    HealBot_Enabled[Member_Name]=false;
--    if not HealBot_IsFighting then 
--      HealBot_Action_SetAttribs(button,"Disabled")
--    end
    if HealBot_Ressing[Member_Name] then
      if UnitDead then
        sr=0.2;
        sg=1.0;
        sb=0.2;
        sa=1;
      else
        HealBot_Ressing[Member_Name]=nil
        sr=HealBot_Config.btextdisbledcolr[HealBot_Config.Current_Skin];
        sg=HealBot_Config.btextdisbledcolg[HealBot_Config.Current_Skin];
        sb=HealBot_Config.btextdisbledcolb[HealBot_Config.Current_Skin];
        sa=HealBot_Config.btextdisbledcola[HealBot_Config.Current_Skin];
      end
    elseif HealBot_IsCasting and HealBot_CastingTarget==unit and hlth+HealBot_HealsIn[Member_Name]>maxhlth and HealBot_Config.BarHealthIncHeals==1 then
     if HealBot_Config.SetClassColourText==1 then
        sr,sg,sb = ClassColR[Member_Name],ClassColG[Member_Name],ClassColB[Member_Name];
        sa = 1;
     end
    elseif UnitDead and Member_Name~=HealBot_PlayerName then
      if SmartCast_Res and IsSpellInRange(SmartCast_Res, unit)==1 then
        sr=0;
        sg=0;
        sb=0;
        sa=1;
      else
        sr=HealBot_Config.btextdisbledcolr[HealBot_Config.Current_Skin];
        sg=HealBot_Config.btextdisbledcolg[HealBot_Config.Current_Skin];
        sb=HealBot_Config.btextdisbledcolb[HealBot_Config.Current_Skin];
        sa=HealBot_Config.btextdisbledcola[HealBot_Config.Current_Skin];
      end
    else
      sr=HealBot_Config.btextdisbledcolr[HealBot_Config.Current_Skin];
      sg=HealBot_Config.btextdisbledcolg[HealBot_Config.Current_Skin];
      sb=HealBot_Config.btextdisbledcolb[HealBot_Config.Current_Skin];
      sa=HealBot_Config.btextdisbledcola[HealBot_Config.Current_Skin];
    end
    bar:SetStatusBarColor(r,g,b,HealBot_Config.bardisa[HealBot_Config.Current_Skin]);
    bar2:SetStatusBarColor(r,g,b,HealBot_Config.bardisa[HealBot_Config.Current_Skin]);
    bar3:SetStatusBarColor(Bar3ColR[Member_Name],Bar3ColG[Member_Name],Bar3ColB[Member_Name],HealBot_Config.bardisa[HealBot_Config.Current_Skin])
    if unit==HealBot_Action_TooltipUnit and not HealBot_IsFighting then
      HealBot_Action_TooltipUnit = nil;
      HealBot_Action_DisableTooltipUnit = unit;
      HealBot_Action_RefreshDisabledTooltip(unit);
    end
  end

  if HealBot_Config.ShowClassOnBar==1 and HealBot_UnitClass[name] then
      if HealBot_Config.ShowClassOnBarWithName==1 then
        name=HealBot_UnitClass[name]..":"..name;
      else
        name=HealBot_UnitClass[name];
      end
  end
  
  local barText ="";
  if HealBot_Config.ShowHealthOnBar==1 and maxhlth then
    if HealBot_Config.BarHealthType==1 then
      local hlthdelta=0;
      if HealBot_Config.BarHealthIncHeals==1 then
        hlthdelta=(hlth+HealBot_HealsIn[Member_Name])-maxhlth;
      else
        hlthdelta=hlth-maxhlth;
      end
      if hlthdelta>0 then
        barText=" +"..hlthdelta;
      else
        barText=" ("..hlthdelta..")";
      end
    else
      if HealBot_Config.BarHealthIncHeals==1 then
        barText=" ("..floor(((hlth+HealBot_HealsIn[Member_Name])/maxhlth)*100).."%)"
      else
        barText=" ("..floor((hlth/maxhlth)*100).."%)"
      end
    end
	textlen=textlen-string.len(barText)
	if textlen<1 then textlen=1; end
  end
  
  if string.len(Member_Name)>textlen then
    barText = string.sub(name,1,textlen) .. '..'..barText;
  else
    barText = name..barText;
  end
  bar.txt:SetText(barText);
  bar.txt:SetTextColor(sr,sg,sb,sa);
end

function HealBot_Action_EnableButtons()
  table.foreach(HealBot_Action_HealButtons, function (index,button)
    HealBot_Action_EnableButton(button);
  end);
end
  
function HealBot_Action_RefreshButton(button)
  if not button then return end
  if type(button)~="table" then DEFAULT_CHAT_FRAME:AddMessage("***** "..type(button)) end
  HealBot_Action_EnableButton(button)
end

function HealBot_Action_ResetSkin()
  local bwidth = HealBot_Config.bwidth[HealBot_Config.Current_Skin];
  local bheight=HealBot_Config.bheight[HealBot_Config.Current_Skin];
  local br=HealBot_Config.headbarcolr[HealBot_Config.Current_Skin];  
  local bg=HealBot_Config.headbarcolg[HealBot_Config.Current_Skin];
  local bb=HealBot_Config.headbarcolb[HealBot_Config.Current_Skin];
  local ba=HealBot_Config.headbarcola[HealBot_Config.Current_Skin];
  local sr=HealBot_Config.headtxtcolr[HealBot_Config.Current_Skin];  
  local sg=HealBot_Config.headtxtcolg[HealBot_Config.Current_Skin];
  local sb=HealBot_Config.headtxtcolb[HealBot_Config.Current_Skin];
  local sa=HealBot_Config.headtxtcola[HealBot_Config.Current_Skin];
  local btexture=HealBot_Config.btexture[HealBot_Config.Current_Skin];
  local btextheight=HealBot_Config.btextheight[HealBot_Config.Current_Skin];

  for j=1,59 do
    local b=getglobal("HealBot_Action_HealUnit"..j);
    local bar = HealBot_Action_HealthBar(b);
    local bar2 = HealBot_Action_HealthBar2(b);
    local bar3 = HealBot_Action_HealthBar3(b);
    bar.txt = getglobal(bar:GetName().."_text");
    bar:SetHeight(bheight);
    bar:SetStatusBarTexture("Interface\\AddOns\\HealBot\\images\\bar"..btexture);
    bar.txt:SetTextHeight(btextheight);
    local barScale = bar:GetScale();
    bar:SetScale(barScale + 0.01);
    bar:SetScale(barScale);
    bar2:SetHeight(bheight);
    bar2:SetStatusBarTexture("Interface\\AddOns\\HealBot\\images\\bar"..btexture);
    bar3:SetHeight(HealBot_Config.bar2size[HealBot_Config.Current_Skin]);
    bar3:SetStatusBarTexture("Interface\\AddOns\\HealBot\\images\\bar"..btexture);
    b:SetHeight(bheight);  
    b:Enable();
    if HealBot_Config.bar2size[HealBot_Config.Current_Skin]==0 then
      bar3:SetHeight(1);
      bar3:SetMinMaxValues(0,100);
      bar3:SetValue(0);
      bar3:SetStatusBarColor(0,0,0)
    end
  end
  for j=71,80 do
    local b=getglobal("HealBot_Action_HealUnit"..j);
    local bar = HealBot_Action_HealthBar(b);
    local bar2 = HealBot_Action_HealthBar2(b);
    local bar3 = HealBot_Action_HealthBar3(b);
    bar.txt = getglobal(bar:GetName().."_text");
    bar:SetHeight(bheight);
    bar:SetStatusBarTexture("Interface\\AddOns\\HealBot\\images\\bar"..btexture);
    bar.txt:SetTextHeight(btextheight);
    local barScale = bar:GetScale();
    bar:SetScale(barScale + 0.01);
    bar:SetScale(barScale);
    bar2:SetHeight(bheight);
    bar2:SetStatusBarTexture("Interface\\AddOns\\HealBot\\images\\bar"..btexture);
    bar3:SetHeight(HealBot_Config.bar2size[HealBot_Config.Current_Skin]);
    bar3:SetStatusBarTexture("Interface\\AddOns\\HealBot\\images\\bar"..btexture);
    b:SetHeight(bheight);  
    b:Enable();
    if HealBot_Config.bar2size[HealBot_Config.Current_Skin]==0 then
      bar3:SetHeight(1);
      bar3:SetMinMaxValues(0,100);
      bar3:SetValue(0);
      bar3:SetStatusBarColor(0,0,0)
    end
  end
  for j=1,20 do
    local h=getglobal("HealBot_Action_Header"..j);
    local bar = HealBot_Action_HealthBar(h);
    local hwidth = bwidth*HealBot_Config.headwidth[HealBot_Config.Current_Skin]
    local hheight = ceil(bheight*0.8)
    h:SetHeight(hheight);
    h:SetWidth(hwidth);
    bar:SetStatusBarTexture("Interface\\AddOns\\HealBot\\images\\bar"..HealBot_Config.headtexture[HealBot_Config.Current_Skin]);
    bar:SetMinMaxValues(0,100);
    bar:SetValue(100);
    bar:SetStatusBarColor(br,bg,bb,ba);
    bar:SetHeight(hheight);
    bar.txt = getglobal(bar:GetName().."_text");
    bar.txt:SetTextColor(sr,sg,sb,sa);
    h:Disable();
  end
  local bar = HealBot_Action_HealthBar(HealBot_Action_OptionsButton);
  bar:SetStatusBarColor(0.1,0.1,0.4,0);
  bar.txt = getglobal(bar:GetName().."_text");
  bar.txt:SetTextColor(0.8,0.8,0.2,0.85);
  bar.txt:SetText(HEALBOT_ACTION_OPTIONS);
  HealBot_Action_ResetUnitStatus()
  Delay_RecalcParty=3;
  if HealBot_Options:IsVisible() then 
    HealBot_DiseaseColorpick:SetStatusBarTexture("Interface\\AddOns\\HealBot\\images\\bar"..HealBot_Config.btexture[HealBot_Config.Current_Skin]);
    HealBot_MagicColorpick:SetStatusBarTexture("Interface\\AddOns\\HealBot\\images\\bar"..HealBot_Config.btexture[HealBot_Config.Current_Skin]);
    HealBot_PoisonColorpick:SetStatusBarTexture("Interface\\AddOns\\HealBot\\images\\bar"..HealBot_Config.btexture[HealBot_Config.Current_Skin]);
    HealBot_CurseColorpick:SetStatusBarTexture("Interface\\AddOns\\HealBot\\images\\bar"..HealBot_Config.btexture[HealBot_Config.Current_Skin]);
    HealBot_EnTextColorpick:SetStatusBarTexture("Interface\\AddOns\\HealBot\\images\\bar"..HealBot_Config.btexture[HealBot_Config.Current_Skin]);
    HealBot_EnTextColorpickin:SetStatusBarTexture("Interface\\AddOns\\HealBot\\images\\bar"..HealBot_Config.btexture[HealBot_Config.Current_Skin]);
    HealBot_DisTextColorpick:SetStatusBarTexture("Interface\\AddOns\\HealBot\\images\\bar"..HealBot_Config.btexture[HealBot_Config.Current_Skin]);
    HealBot_DebTextColorpick:SetStatusBarTexture("Interface\\AddOns\\HealBot\\images\\bar"..HealBot_Config.btexture[HealBot_Config.Current_Skin]);
    HealBot_HeadBarColorpick:SetStatusBarTexture("Interface\\AddOns\\HealBot\\images\\bar"..HealBot_Config.headtexture[HealBot_Config.Current_Skin]);
    HealBot_HeadTextColorpick:SetStatusBarTexture("Interface\\AddOns\\HealBot\\images\\bar"..HealBot_Config.headtexture[HealBot_Config.Current_Skin]);
    HealBot_Buff1Colour:SetStatusBarTexture("Interface\\AddOns\\HealBot\\images\\bar"..HealBot_Config.btexture[HealBot_Config.Current_Skin]);
    HealBot_Buff2Colour:SetStatusBarTexture("Interface\\AddOns\\HealBot\\images\\bar"..HealBot_Config.btexture[HealBot_Config.Current_Skin]);
    HealBot_Buff3Colour:SetStatusBarTexture("Interface\\AddOns\\HealBot\\images\\bar"..HealBot_Config.btexture[HealBot_Config.Current_Skin]);
    HealBot_Buff4Colour:SetStatusBarTexture("Interface\\AddOns\\HealBot\\images\\bar"..HealBot_Config.btexture[HealBot_Config.Current_Skin]);
    HealBot_Buff5Colour:SetStatusBarTexture("Interface\\AddOns\\HealBot\\images\\bar"..HealBot_Config.btexture[HealBot_Config.Current_Skin]);
    HealBot_Buff6Colour:SetStatusBarTexture("Interface\\AddOns\\HealBot\\images\\bar"..HealBot_Config.btexture[HealBot_Config.Current_Skin]);
    HealBot_Buff7Colour:SetStatusBarTexture("Interface\\AddOns\\HealBot\\images\\bar"..HealBot_Config.btexture[HealBot_Config.Current_Skin]);
    HealBot_Buff8Colour:SetStatusBarTexture("Interface\\AddOns\\HealBot\\images\\bar"..HealBot_Config.btexture[HealBot_Config.Current_Skin]);
    HealBot_Buff9Colour:SetStatusBarTexture("Interface\\AddOns\\HealBot\\images\\bar"..HealBot_Config.btexture[HealBot_Config.Current_Skin]);
    HealBot_SetSkinColours()
  end
end

function HealBot_Action_RefreshButtons(unit)
  if unit and HealBot_Action_UnitButtons[unit] then
    table.foreach(HealBot_Action_UnitButtons[unit], function (index,button)
      HealBot_Action_RefreshButton(button);
    end);
  else
    table.foreach(HealBot_Action_HealButtons, function (index,button)
      local Unit_Status=HealBot_UnitStatus[button.unit];
      local Unit_Group=HealBot_UnitGroup[button.unit];
      if Unit_Status and Unit_Group then
        if HealBot_Config.EnableHealthy==1 then
          HealBot_Action_RefreshButton(button);
        elseif Unit_Status~=0 then
          if Unit_Status==1 then
            HealBot_Action_RefreshButton(button);
          elseif Unit_Status==3 then
            if Unit_Group==HealBot_CheckGroup then
              HealBot_Action_RefreshButton(button);
            end
          else
            if HealBot_CycleChecks==1 then
              if Unit_Group>HealBot_CycleMidPoint then
                HealBot_Action_RefreshButton(button);
              end
            else
              if Unit_Group<=HealBot_CycleMidPoint then
                HealBot_Action_RefreshButton(button);
              end
            end
          end
        end
      end
    end);
    HealBot_CycleChecks=HealBot_CycleChecks+1;
    HealBot_CheckGroup=HealBot_CheckGroup+1;
    if HealBot_CheckGroup>HealBot_MaxGroup then HealBot_CheckGroup=1; end
    if HealBot_CycleChecks>2 then HealBot_CycleChecks=1; end
  end
end

function HealBot_Action_ResetUnitStatus(unit)
  if unit then
    if HealBot_UnitStatus[unit] then
      HealBot_UnitStatus[unit]=1;
    end
  else
    for j in pairs(HealBot_UnitID) do
      local id=HealBot_UnitID[j]
      if HealBot_UnitStatus[id]~=1 then
        HealBot_UnitStatus[id]=2;
      end
    end
  end
end

function HealBot_Action_PositionButton(button,OsetX,OsetY,bwidth,bheight,checked,header)
  local brspace=HealBot_Config.brspace[HealBot_Config.Current_Skin];
  if header then
    headerno=headerno+1;
    local h=getglobal("HealBot_Action_Header"..headerno);
    local bar = HealBot_Action_HealthBar(h);
    local hwidth = bwidth*HealBot_Config.headwidth[HealBot_Config.Current_Skin]
    local hheight = ceil(bheight*0.8)
    local hwidthadj = ceil((bwidth-hwidth)/2);
    local hrspace = ceil(brspace*1.4)+3
    h:ClearAllPoints();
    h:SetPoint("TOPLEFT","HealBot_Action","TOPLEFT",OsetX+hwidthadj,-OsetY);
    h:Show();
    bar.txt = getglobal(bar:GetName().."_text");
    bar.txt:SetText(header);
    OsetY = OsetY+hheight+hrspace;
  else
    button:ClearAllPoints();
    button:Show();
    if checked then
      button:SetWidth(bwidth-14);
      button:SetPoint("TOPLEFT","HealBot_Action","TOPLEFT",OsetX+14,-OsetY);
    else
      button:SetWidth(bwidth);
      button:SetPoint("TOPLEFT","HealBot_Action","TOPLEFT",OsetX,-OsetY);
    end
    OsetY = OsetY+bheight+brspace+HealBot_Config.bar2size[HealBot_Config.Current_Skin];
  end
  return OsetY;
end

function HealBot_Action_SetHeightWidth(width,height,bwidth)
  if HealBot_ActionHeight then
    HealBot_Action:SetHeight(HealBot_ActionHeight);
  end
  if HealBot_Config.GrowUpwards==1 then
    local left,bottom = HealBot_Action:GetLeft(),HealBot_Action:GetBottom();
    if left and bottom then
      if HealBot_Config.PanelAnchorX==-1 then HealBot_Config.PanelAnchorX=left; end
      if HealBot_Config.PanelAnchorY==-1 then HealBot_Config.PanelAnchorY=bottom; end
      HealBot_Action:ClearAllPoints();
      HealBot_Action:SetPoint("BOTTOMLEFT","UIParent","BOTTOMLEFT",HealBot_Config.PanelAnchorX,HealBot_Config.PanelAnchorY);
    end
  else
    local left,top = HealBot_Action:GetLeft(),HealBot_Action:GetTop();
    if left and top then
      HealBot_Action:ClearAllPoints();
      HealBot_Action:SetPoint("TOPLEFT","UIParent","BOTTOMLEFT",left,top);
    end
  end
  HealBot_Action:SetHeight(height);
  HealBot_ActionHeight = height;
  HealBot_Action:SetWidth(width+bwidth+10)
end

function HealBot_Action_SetHealButton(index,unit,Member_Name)
--  local HealButtonOnClick = function() HealBot_Action_HealUnit_OnClick(this,arg1) end
  local button="HealBot_Action_HealUnit"..index
  local b=getglobal(button);
  if unit then
    table.insert(HealBot_Action_HealButtons,b);
    if not HealBot_Action_UnitButtons[unit] then HealBot_Action_UnitButtons[unit] = {} end
    table.insert(HealBot_Action_UnitButtons[unit],b);

    if HealBot_TrackButtons[button] then
      HealBot_TrackButtons[button]=nil;
    end
    if not HealBot_UnitID[Member_Name] then
      HealBot_UnitID[Member_Name]="niL";
      HealBot_UnitClass[Member_Name] = UnitClass(unit);
      HealBot_UnitLevel[Member_Name] = UnitLevel(unit);
      ClassColR[Member_Name],ClassColG[Member_Name],ClassColB[Member_Name] = HealBot_Action_ClassColour(HealBot_UnitClass[Member_Name]);
      if UnitIsPlayer(unit) then
        if not HealBot_HealsIn[Member_Name] then
          HealBot_HealsIn[Member_Name]=0;
          if HealBot_Config.BuffWatch==1 then HealBot_DelayBuffCheck[unit]=true; end
          if HealBot_Config.DebuffWatch==1 then HealBot_DelayDebuffCheck[unit]=true; end
        end
      end
    end
    if not HealBot_Unit_Button[Member_Name] or unit=="target" or HealBot_UnitID[Member_Name]~=unit then
      HealBot_Unit_Button[Member_Name]="init";
      HealBot_UnitStatus[unit]=1;
    end
    if HealBot_Unit_Button[Member_Name]~=button then
      b.unit = unit;
      b:SetAttribute("unit", unit);
      HealBot_Unit_Button[Member_Name]=button;
      HealBot_TrackManaBar[Member_Name]=false;
      HealBot_UnitStatus[unit]=1;
      HealBot_UnitID[Member_Name] = unit;
      if not HealBot_Prev_State[button] then
        HealBot_Prev_State[button]="init";
      end
    end
  
--    if HealBot_UnitStatus[unit]==0 then
--      HealBot_UnitStatus[unit]=3;
--    end
    
    if HealBot_IsFighting or HealBot_Enabled[Member_Name] then
      if HealBot_Prev_State[button]~="Enabled" then
        HealBot_Prev_State[button]="Enabled"
        HealBot_Action_SetAttribs(b,"Enabled")
      end
    end

  end
end

function HealBot_Action_ResetAttribButtons()
  HealBot_Prev_State={};
end

function HealBot_Action_SetAttribs(button,status)

HealBot_Keys_List = {
"",
"Shift",
"Ctrl",
"Alt"
}
  local HB_prefix;
  local HB_combo_prefix;
  local SpellTxt;
  
  if HealBot_IsFighting then status = "Enabled"; end
  
  for j=1,5 do
    local HB_button="";
    if j==1 then HB_button="Left";
    elseif j==2 then HB_button="Right";
    elseif j==3 then HB_button="Middle";
    elseif j==4 then HB_button="Button4";
    elseif j==5 then HB_button="Button5";
    end
    
    for i=1, getn(HealBot_Keys_List), 1 do
      HB_combo_prefix = HealBot_Keys_List[i];
      if strlen(HB_combo_prefix)>1 then
        HB_prefix = strlower(HB_combo_prefix).."-"
      else
        HB_prefix = "";
      end
      HB_combo_prefix = HB_combo_prefix..HB_button;
      if status=="Enabled" then
        SpellTxt = HealBot_Action_AttribSpellPattern(HB_combo_prefix,HealBot_PlayerClass)
      elseif status=="Disabled" then
        SpellTxt = HealBot_Action_AttribDisSpellPattern(HB_combo_prefix,HealBot_PlayerClass)
      else
        SpellTxt=nil;
      end
      if SpellTxt then
        if strlower(SpellTxt)=="target" then
          button:SetAttribute(HB_prefix.."helpbutton"..j, "target"..j);
		  button:SetAttribute(HB_prefix.."type"..j, "target")
          button:SetAttribute(HB_prefix.."type-target"..j, "target")
        elseif strlower(SpellTxt)=="focus" then
          button:SetAttribute(HB_prefix.."helpbutton"..j, "focus"..j);
		  button:SetAttribute(HB_prefix.."type"..j, "focus")
          button:SetAttribute(HB_prefix.."type-focus"..j, "focus")
        elseif strlower(SpellTxt)=="assist" then
          button:SetAttribute(HB_prefix.."helpbutton"..j, "assist"..j);
--		  button:SetAttribute(HB_prefix.."type"..j, "assist")
          button:SetAttribute(HB_prefix.."type-assist"..j, "assist")
        else
          local SpellID=HealBot_GetSpellId(SpellTxt)
          if SpellID then
            button:SetAttribute(HB_prefix.."helpbutton"..j, "heal"..j);
            button:SetAttribute(HB_prefix.."type-heal"..j, "spell");
            button:SetAttribute(HB_prefix.."spell-heal"..j, SpellTxt);
          else
            button:SetAttribute(HB_prefix.."helpbutton"..j, "item"..j);
            button:SetAttribute(HB_prefix.."type-item"..j, "item");
            button:SetAttribute(HB_prefix.."item-item"..j, SpellTxt);
          end
        end
      else
        button:SetAttribute(HB_prefix.."helpbutton"..j, nil);
      end
    end
  end

end


function HealBot_Action_AttribSpellPattern(HB_combo_prefix,class)
  local combos = HealBot_Config.KeyCombo[class]
  if not combos then return nil end
  return combos[HB_combo_prefix]
end

function HealBot_Action_AttribDisSpellPattern(HB_combo_prefix,class)
  local combos = HealBot_Config.DisKeyCombo[class]
  if not combos then return nil end
  return combos[HB_combo_prefix]
end

local HealBot_PlayerRaidID=1;
function HealBot_Action_PartyChanged(HealBot_PreCombat)

if not HealBot_IsFighting then
 
  if HealBot_PreCombat then 
    HealBot_IsFighting=true;
  end
  
  HealBot_Action_HealButtons = {};
  HealBot_Action_UnitButtons = {};
  HealBot_UnitName = {};
  HealBot_UnitGroup={};
  HealBot_CheckGroup=1;
  HealBot_MaxGroup=1;

  local numBars = 0;
  local numHeaders = 0;
  local TempMaxH=0;
  local HeaderPos = {};

  for j=1,headerno do
    local headerobj=getglobal("HealBot_Action_Header"..j);
    headerobj:SetText(" ")
    headerobj:Hide();
  end

  local bwidth = HealBot_Config.bwidth[HealBot_Config.Current_Skin];
  local bheight=HealBot_Config.bheight[HealBot_Config.Current_Skin];
  local bcspace=HealBot_Config.bcspace[HealBot_Config.Current_Skin];
  local cols=HealBot_Config.numcols[HealBot_Config.Current_Skin];
  local checked_start=0;
  local checked_end=0;
  local nraid=GetNumRaidMembers();
  local HaveTarget=false;
  local MyGroup=0;
  headerno=0;
  
--  for j=1,41 do
--    HealBot_Action_SetHealButton(j,nil,nil);
--  end
--  for j=51,60 do
--    HealBot_Action_SetHealButton(j,nil,nil);
--  end
    local i = 0;
    local GroupValid=numBars;
    
    if HealBot_Config.SelfHeals==1 then
       if HealBot_Config.ShowHeader[HealBot_Config.Current_Skin]==1 then
        HeaderPos[i+1] = HEALBOT_OPTIONS_SELFHEALS
       end
        unit="player";
        local Member_Name=UnitName(unit);
        if not HealBot_Action_UnitButtons[unit] and HealBot_MayHeal(unit, Member_Name) then
          i = i+1;
          HealBot_UnitName[unit] = Member_Name;
          HealBot_Action_SetHealButton(i,unit,Member_Name);
          numBars=numBars+1;
        end
        unit="pet";
        local Member_Name=UnitName(unit);
        if not HealBot_Action_UnitButtons[unit] and HealBot_MayHeal(unit, Member_Name) then
          i = i+1;
          HealBot_UnitName[unit] = Member_Name;
          HealBot_Action_SetHealButton(i,unit,Member_Name);
          numBars=numBars+1;
        end
      if numBars>GroupValid and HealBot_Config.ShowHeader[HealBot_Config.Current_Skin]==1 then
        numBars=numBars+1;
        numHeaders=numHeaders+1;
      end
    end

    
    if HealBot_Config.GroupHeals==1 then
       if HealBot_Config.ShowHeader[HealBot_Config.Current_Skin]==1 then
        HeaderPos[i+1] = HEALBOT_OPTIONS_GROUPHEALS
        MyGroup=i+1;
       end
      for _,unit in ipairs(HealBot_Action_HealGroup) do
        local Member_Name=UnitName(unit);
        if not HealBot_Action_UnitButtons[unit] and HealBot_MayHeal(unit, Member_Name) then
          i = i+1;
          HealBot_UnitName[unit] = Member_Name;
          HealBot_Action_SetHealButton(i,unit,Member_Name);
          numBars=numBars+1;
        end
      end
      if numBars>GroupValid and HealBot_Config.ShowHeader[HealBot_Config.Current_Skin]==1 then
        numBars=numBars+1;
        numHeaders=numHeaders+1;
      else
        MyGroup=0;
      end
    end
    
    local TankValid=numBars;
    if HealBot_Config.TankHeals==1 and nraid>0 then
      if HealBot_Config.ShowHeader[HealBot_Config.Current_Skin]==1 then
        HeaderPos[i+1] = HEALBOT_OPTIONS_TANKHEALS
      end
      for j=1,10 do
        if HealBot_MainTanks[j] then
          for k=1,nraid do
            local unit = "raid"..k;
            local PossibleMT=1;
            if UnitInParty(unit) and HealBot_Config.GroupHeals==1 then 
              if not UnitIsUnit(unit, "player") then
                PossibleMT=0;
              end
            end
            if PossibleMT==1 then 
              local Member_Name=UnitName(unit);
              if Member_Name==HealBot_MainTanks[j] then
                if not HealBot_Action_UnitButtons[unit] and HealBot_MayHeal(unit, Member_Name) then
                  i = i+1;
                  HealBot_UnitName[unit] = Member_Name;
                  HealBot_Action_SetHealButton(i,unit,Member_Name);
                  numBars=numBars+1;
                end
              end
            end
          end
        end
        if i>15 then break end
      end
      if numBars>TankValid and HealBot_Config.ShowHeader[HealBot_Config.Current_Skin]==1 then
        numBars=numBars+1;
        numHeaders=numHeaders+1;
      end
    end
    
    local h=70;
    local TargetValid=numBars;
    if HealBot_Config.TargetHeals==1 then
      if HealBot_Config.ShowHeader[HealBot_Config.Current_Skin]==1 then
        HeaderPos[i+1] = HEALBOT_OPTIONS_TARGETHEALS
      end
      for _,unit in ipairs(HealBot_Action_HealTarget) do
        local Member_Name=UnitName(unit);
        if not HealBot_Action_UnitButtons[unit] and HealBot_MayHeal(unit, Member_Name) then
          i = i+1;
          h = h+1;
          HealBot_UnitName[unit] = Member_Name;
          if checked_start==0 then checked_start=i; end
          checked_end=i;
          HealBot_Action_SetHealButton(h,unit,Member_Name);
          local check = getglobal("HealBot_Action_HealUnit"..h.."Check");
          check.unit = unit;
          check:SetChecked(1);
          check:Show();
          numBars=numBars+1;
        end
      end

     if not HealBot_PreCombat then
      unit = HealBot_TargetName()
      local Member_Name;
      if unit then
        Member_Name=UnitName(unit);
        HealBot_UnitName[unit] = Member_Name;
      else
        Member_Name=UnitName("target");
        unit="target";
      end
      if not HealBot_Action_UnitButtons[unit] and HealBot_MayHeal(unit, Member_Name) then
        i = i+1;
        h = h+1;
        if h<81 then
          HealBot_Action_SetHealButton(h,unit,Member_Name);
          local check = getglobal("HealBot_Action_HealUnit"..h.."Check");

          check:SetChecked(0);
          check.unit = unit;
          if unit~="target" then
            if checked_start==0 then checked_start=i; end
            checked_end=i;          
            check:Show();
          else
            check:Hide();
          end
        else
          HealBot_Action_SetHealButton(i,unit,Member_Name);
        end
        numBars=numBars+1;
        HaveTarget=true;
        TargetButton="HealBot_Action_HealUnit"..h;
        HealBot_UnitName["target"] = Member_Name;
        HealBot_UnitClass[Member_Name] = UnitClass("target");
        HealBot_UnitLevel[Member_Name] = UnitLevel("target");
      end
     end
     if numBars>TargetValid and HealBot_Config.ShowHeader[HealBot_Config.Current_Skin]==1 then
       numBars=numBars+1;
       numHeaders=numHeaders+1;
     end
    end

    
    local ExtraValid=numBars;
    if HealBot_Config.EmergencyHeals==1 then
      local order = {};
      local units = {};
      if HealBot_Config.ShowHeader[HealBot_Config.Current_Skin]==1 and HealBot_Config.ExtraOrder==1 then
        HeaderPos[i+1] = HEALBOT_OPTIONS_EMERGENCYHEALS
        numBars=numBars+1;
        numHeaders=numHeaders+1;
      end
      if HealBot_Config.EmergIncMonitor==1 then
        if nraid>0 then
          for j=1,40 do
            local PossibleEmerg=1;
            local unit = "raid"..j;
            local Member_Name=UnitName(unit);
            if Member_Name then
              local name, rank, subgroup, level, class, fileName, zone, online, isDead = GetRaidRosterInfo(j);
            
              if UnitInParty(unit) and HealBot_Config.GroupHeals==1 then
                PossibleEmerg=0;
              elseif not HealBot_Config.ExtraIncGroup[subgroup] then
                PossibleEmerg=0;
              end
              if Member_Name==HealBot_PlayerName then
                if HealBot_Config.SelfHeals==1 then
                  PossibleEmerg=0;
                end
                if MyGroup>0 then
                  HeaderPos[MyGroup] = HEALBOT_OPTIONS_GROUPHEALS.." "..subgroup;
                end
              end
              if PossibleEmerg==1 then 
                if not HealBot_Action_UnitButtons[unit] and HealBot_MayHeal(unit, name) then
                  if HealBot_Config.ExtraOrder==1 then
                    order[unit] = name;
                  elseif HealBot_Config.ExtraOrder==2 then
                    order[unit] = class;
                  elseif HealBot_Config.ExtraOrder==3 then
                    order[unit] = subgroup;
                  else
                    order[unit] = 0-UnitHealthMax(unit);
                    if UnitHealthMax(unit)>TempMaxH then TempMaxH=UnitHealthMax(unit); end
                  end
                  table.insert(units,unit);
                  numBars=numBars+1;
                  HealBot_UnitGroup[unit] = subgroup;
                  HealBot_UnitName[unit] = Member_Name;
                end
              end
            end
          end
        else
          for j=1,4 do
            local PossibleEmerg=1;
            local unit = "party"..j;
            local Member_Name=UnitName(unit);
            if Member_Name then
              local class = UnitClass(unit);
              local subgroup = 1;
              local name = Member_Name;
            
              if UnitInParty(unit) and HealBot_Config.GroupHeals==1 then
                PossibleEmerg=0;
              elseif not HealBot_Config.ExtraIncGroup[subgroup] then
                PossibleEmerg=0;
              elseif Member_Name==HealBot_PlayerName and HealBot_Config.SelfHeals==1 then
                PossibleEmerg=0;
              end
              if PossibleEmerg==1 then 
                if not HealBot_Action_UnitButtons[unit] and HealBot_MayHeal(unit, name) then
                  if HealBot_Config.ExtraOrder==1 then
                    order[unit] = name;
                  elseif HealBot_Config.ExtraOrder==2 then
                    order[unit] = class;
                  elseif HealBot_Config.ExtraOrder==3 then
                    order[unit] = subgroup;
                  else
                    order[unit] = 0-UnitHealthMax(unit);
                    if UnitHealthMax(unit)>TempMaxH then TempMaxH=UnitHealthMax(unit); end
                  end
                  table.insert(units,unit);
                  numBars=numBars+1;
                  HealBot_UnitGroup[unit] = subgroup;
                  HealBot_UnitName[unit] = Member_Name;
                end
              end
            end
          end
        end
      else
        if nraid>0 then
          for j=1,40 do
 
            local unit = "raid"..j;
            local Class = UnitClass(unit);
            local Member_Name=UnitName(unit);
            if Member_Name then
              local ProcessUnit = 1;
              local PossibleEmerg=1;
              local name, rank, subgroup, level, class, fileName, zone, online, isDead = GetRaidRosterInfo(j);
              
              if UnitInParty(unit) and HealBot_Config.GroupHeals==1 then
                PossibleEmerg=0;
              elseif HealBot_EmergInc[Class]~=1 then 
                ProcessUnit = 0;
              elseif not HealBot_Config.ExtraIncGroup[subgroup] then
                PossibleEmerg=0;
              end                    
              if Member_Name==HealBot_PlayerName then
                if HealBot_Config.SelfHeals==1 then
                  PossibleEmerg=0;
                end
                if MyGroup>0 then
                  HeaderPos[MyGroup] = HEALBOT_OPTIONS_GROUPHEALS.." "..subgroup;
                end
              end
              if ProcessUnit==1 and PossibleEmerg==1 then
                if not HealBot_Action_UnitButtons[unit] and HealBot_MayHeal(unit, name) then
                  if HealBot_Config.ExtraOrder==1 then
                    order[unit] = name;
                  elseif HealBot_Config.ExtraOrder==2 then
                    order[unit] = class;
                  elseif HealBot_Config.ExtraOrder==3 then
                    order[unit] = subgroup;
                  else
                    order[unit] = 0-UnitHealthMax(unit);
                    if UnitHealthMax(unit)>TempMaxH then TempMaxH=UnitHealthMax(unit); end
                  end
                  table.insert(units,unit);
                  numBars=numBars+1;
                  HealBot_UnitGroup[unit] = subgroup;
                  HealBot_UnitName[unit] = Member_Name;
                end
              end
            end
          end
        else
          for j=1,4 do
 
            local unit = "party"..j;
            local Class = UnitClass(unit);
            local Member_Name=UnitName(unit);
            if Member_Name then
              local ProcessUnit = 1;
              local PossibleEmerg=1;
              local name = Member_Name;
              local subgroup = 1;
              
              if UnitInParty(unit) and HealBot_Config.GroupHeals==1 then
                PossibleEmerg=0;
              elseif HealBot_EmergInc[Class]~=1 then 
                ProcessUnit = 0;
              elseif not HealBot_Config.ExtraIncGroup[subgroup] then
                PossibleEmerg=0;
              elseif Member_Name==HealBot_PlayerName and HealBot_Config.SelfHeals==1 then
                PossibleEmerg=0;
              end
              if ProcessUnit==1 and PossibleEmerg==1 then
                if not HealBot_Action_UnitButtons[unit] and HealBot_MayHeal(unit, name) then
                  if HealBot_Config.ExtraOrder==1 then
                    order[unit] = name;
                  elseif HealBot_Config.ExtraOrder==2 then
                    order[unit] = class;
                  elseif HealBot_Config.ExtraOrder==3 then
                    order[unit] = subgroup;
                  else
                    order[unit] = 0-UnitHealthMax(unit);
                    if UnitHealthMax(unit)>TempMaxH then TempMaxH=UnitHealthMax(unit); end
                  end
                  table.insert(units,unit);
                  numBars=numBars+1;
                  HealBot_UnitGroup[unit] = subgroup;
                  HealBot_UnitName[unit] = Member_Name;
                end
              end
            end
          end
        end
      end
      table.sort(units,function (a,b)
        if order[a]<order[b] then return true end
        if order[a]>order[b] then return false end
        return a<b
      end)
      local TempSort="init"
      TempMaxH=ceil(TempMaxH/1000)*1000;
                
        for j=1,40 do
          if not units[j] then break end
          local unit=units[j];
          local Member_Name = HealBot_UnitName[unit];
          if HealBot_Config.ShowHeader[HealBot_Config.Current_Skin]==1 then
            
--            local name, rank, subgroup, level, class, fileName, zone, online, isDead = GetRaidRosterInfo(strsub(units[j], 5));
            if HealBot_Config.ExtraOrder==2 and TempSort~=HealBot_UnitClass[Member_Name] then 
              TempSort=HealBot_UnitClass[Member_Name]
              HeaderPos[i+1] = HealBot_UnitClass[Member_Name]
              numBars=numBars+1;
              numHeaders=numHeaders+1;
            end
            if HealBot_Config.ExtraOrder==3 and TempSort~=HealBot_UnitGroup[unit] then
              TempSort=HealBot_UnitGroup[unit]
              HeaderPos[i+1] = HEALBOT_OPTIONS_GROUPHEALS.." "..HealBot_UnitGroup[unit]
              numBars=numBars+1;
              numHeaders=numHeaders+1;
            end
            if HealBot_Config.ExtraOrder==4 and TempMaxH>UnitHealthMax(unit) then
              TempMaxH=TempMaxH-1000
              HeaderPos[i+1] = ">"..tostring(TempMaxH/1000).."k"
              numBars=numBars+1;
              numHeaders=numHeaders+1;
            end
          end
          i = i+1;
          HealBot_Action_SetHealButton(i,unit,Member_Name);
        end
      if numBars==ExtraValid+1 and HealBot_Config.ShowHeader[HealBot_Config.Current_Skin]==1 then
        HeaderPos[i+1] = nil;
        numBars=numBars-1;
      end
    end

    
    if HealBot_Config.PetHeals==1 then
      local PetNames = {};
      PetNames["Unknown"]=true;
      if HealBot_Config.ShowHeader[HealBot_Config.Current_Skin]==1 then
       HeaderPos[i+1] = HEALBOT_OPTIONS_PETHEALS
      end
      if nraid>0 then
        for j=1,40 do
          unit="raidpet"..j;
          local punit="raid"..j;
          local Member_Name=UnitName(unit);
          if not HealBot_Action_UnitButtons[unit] and not PetNames[Member_Name] and HealBot_MayHeal(unit, Member_Name) and UnitInRaid(punit) then
            i = i+1;
            HealBot_UnitName[unit] = Member_Name;
            HealBot_Action_SetHealButton(i,unit,Member_Name);
            numBars=numBars+1;
            PetNames[Member_Name]=true;
          end
          if i>58 then break end
        end
      else
        for j=1,4 do
          unit="partypet"..j;
          local punit="party"..j;
          local Member_Name=UnitName(unit);
          if not HealBot_Action_UnitButtons[unit] and not PetNames[Member_Name] and HealBot_MayHeal(unit, Member_Name) and UnitInParty(punit)  then
            i = i+1;
            HealBot_UnitName[unit] = Member_Name;
            HealBot_Action_SetHealButton(i,unit,Member_Name);
            numBars=numBars+1;
            PetNames[Member_Name]=true;
          end
        end
      end
      if numBars>GroupValid and HealBot_Config.ShowHeader[HealBot_Config.Current_Skin]==1 then
        numBars=numBars+1;
        numHeaders=numHeaders+1;
      end
    end


  OffsetY = 10;
  OffsetX = 10;
  MaxOffsetY=0;
  local i=0;  
  local h=0;
  local mg=0;
  local MaxMinorWounded=HealBot_Config.RangeCheckUnits;
  if (MaxMinorWounded*2)>(numBars-numHeaders) then MaxMinorWounded=ceil(MaxMinorWounded/2); end
  
  if numHeaders>0 then
    i=0;
    table.foreach(HealBot_Action_HealButtons, function (index,button)
      i=i+1;
      local Member_Name=HealBot_UnitName[button.unit];
      if not Member_Name then
        HealBot_UnitName[button.unit]=UnitName(button.unit);
        Member_Name=UnitName(button.unit);
      end
      if Member_Name then
        if HealBot_TrackUnitNames[Member_Name] then
          HealBot_TrackUnitNames[Member_Name]=nil;
        end
        mg=mg+1;
        if mg>=MaxMinorWounded then
          mg=1
          HealBot_MaxGroup=HealBot_MaxGroup+1;
        end
        HealBot_UnitGroup[button.unit]=HealBot_MaxGroup;
        local checked=false;
        local header;
        if HeaderPos[i] then
          h=h+1;
          header=HeaderPos[i];
          if h>cols then
            if MaxOffsetY<OffsetY then MaxOffsetY = OffsetY; end
            OffsetY = 10;
            OffsetX = OffsetX + bwidth+bcspace; 
            h=1;
          end
          OffsetY = HealBot_Action_PositionButton(nil,OffsetX,OffsetY,bwidth,bheight,checked,header);
        end
        if checked_start<=i and checked_end>=i then checked=true; end
        OffsetY = HealBot_Action_PositionButton(button,OffsetX,OffsetY,bwidth,bheight,checked,nil);
        if not HealBot_TrackManaBar[Member_Name] then
          if HealBot_Config.bar2size[HealBot_Config.Current_Skin]>0 then
            local bar3 = HealBot_Action_HealthBar3(button);
            local powertype=UnitPowerType(button.unit);
            Bar3ColR[Member_Name]=0.9;
            Bar3ColG[Member_Name]=0.5;
            Bar3ColB[Member_Name]=0;
            if powertype==0 then
              Bar3ColR[Member_Name]=0;
              Bar3ColG[Member_Name]=0;
              Bar3ColB[Member_Name]=1;
            elseif powertype==1 then
              Bar3ColR[Member_Name]=1;
              Bar3ColG[Member_Name]=0;
              Bar3ColB[Member_Name]=0;
            elseif powertype==2 then
              Bar3ColR[Member_Name]=0.9;
              Bar3ColG[Member_Name]=0.5;
              Bar3ColB[Member_Name]=0;
            elseif powertype==3 then
              Bar3ColR[Member_Name]=1;
              Bar3ColG[Member_Name]=1;
              Bar3ColB[Member_Name]=0;
            elseif powertype==4 then
              Bar3ColR[Member_Name]=0.8;
              Bar3ColG[Member_Name]=0;
              Bar3ColB[Member_Name]=0.8;
            end
            bar3:SetStatusBarColor(Bar3ColR[Member_Name],Bar3ColG[Member_Name],Bar3ColB[Member_Name])
          end
          HealBot_TrackManaBar[Member_Name]=true;
        end
      else
        button:Hide();
      end
    end);
  else

    h=1;
    i=0;
    local z=1;
  
    table.foreach(HealBot_Action_HealButtons, function (index,button)
      i=i+1;
      local Member_Name=HealBot_UnitName[button.unit];
      if not Member_Name then
        HealBot_UnitName[button.unit]=UnitName(button.unit);
        Member_Name=UnitName(button.unit);
      end
      if Member_Name then
        if HealBot_TrackUnitNames[Member_Name] then
          HealBot_TrackUnitNames[Member_Name]=nil;
        end
        mg=mg+1;
        if mg>=MaxMinorWounded then
          mg=1
          HealBot_MaxGroup=HealBot_MaxGroup+1;
        end
        HealBot_UnitGroup[button.unit]=HealBot_MaxGroup;
        local checked=false;

        if checked_start<=i and checked_end>=i then checked=true; end
        OffsetY = HealBot_Action_PositionButton(button,OffsetX,OffsetY,bwidth,bheight,checked,nil);
        if h==ceil((numBars)/cols) and z<numBars then
          h=0;
          if MaxOffsetY<OffsetY then MaxOffsetY = OffsetY; end
          OffsetY = 10;
          OffsetX = OffsetX + bwidth+bcspace; 
        end
        z=z+1;
        h=h+1;
        if not HealBot_TrackManaBar[Member_Name] then
          if HealBot_Config.bar2size[HealBot_Config.Current_Skin]>0 then
            local powertype=UnitPowerType(button.unit);
            local bar3 = HealBot_Action_HealthBar3(button);
            Bar3ColR[Member_Name]=0;
            Bar3ColG[Member_Name]=0;
            Bar3ColB[Member_Name]=0;
            if powertype==0 then
              Bar3ColR[Member_Name]=0;
              Bar3ColG[Member_Name]=0;
              Bar3ColB[Member_Name]=0.8;
            elseif powertype==1 then
              Bar3ColR[Member_Name]=0.8;
              Bar3ColG[Member_Name]=0;
              Bar3ColB[Member_Name]=0;
            elseif powertype==2 then
              Bar3ColR[Member_Name]=0;
              Bar3ColG[Member_Name]=0;
              Bar3ColB[Member_Name]=0;
            elseif powertype==3 then
              Bar3ColR[Member_Name]=0.8;
              Bar3ColG[Member_Name]=0.8;
              Bar3ColB[Member_Name]=0;
            elseif powertype==4 then
              Bar3ColR[Member_Name]=0.8;
              Bar3ColG[Member_Name]=0;
              Bar3ColB[Member_Name]=0.8;
            end
            bar3:SetStatusBarColor(Bar3ColR[Member_Name],Bar3ColG[Member_Name],Bar3ColB[Member_Name])
          end
          HealBot_TrackManaBar[Member_Name]=true;
        end
      else
        button:Hide();
      end
    end);
  end
  
  for Member_Name,_ in pairs(HealBot_TrackUnitNames) do
    HealBot_UnitID[Member_Name] = nil;
    HealBot_UnitClass[Member_Name] = nil;
    HealBot_UnitLevel[Member_Name] = nil;
    HealBot_HealsIn[Member_Name] = nil;
    HealBot_TrackManaBar[Member_Name] = nil;
    HealBot_Enabled[Member_Name]=nil;
    HealBot_TrackUnitNames[Member_Name]=nil;
  end
  for _,Member_Name in pairs(HealBot_UnitName) do
    HealBot_TrackUnitNames[Member_Name]=true;
  end
  for button,_ in pairs(HealBot_TrackButtons) do
    local b=getglobal(button);
    b:Hide();
    HealBot_TrackButtons[button]=nil;
  end
  for _,button in pairs(HealBot_Unit_Button) do
    HealBot_TrackButtons[button]=true;
  end
  if not HaveTarget then
    if TargetButton and not HealBot_TrackButtons[TargetButton] then
      local b=getglobal(TargetButton)
      b:Hide();
    end
  end
  
  HealBot_CycleMidPoint=(HealBot_MaxGroup*0.55);
  if HealBot_CycleMidPoint<1.1 then HealBot_CycleMidPoint=1.1; end

  if MaxOffsetY<OffsetY then MaxOffsetY = OffsetY; end

  if HealBot_Config.HideOptions==1 then
    HealBot_Action_OptionsButton:Hide();
  else
    HealBot_Action_OptionsButton:SetPoint("BOTTOM","HealBot_Action","BOTTOM",0,10);
    HealBot_Action_OptionsButton:Show();
    MaxOffsetY = MaxOffsetY+30;
  end  

  if HealBot_Config.BuffWatch==1 and HealBot_Config.BuffWatchInCombat==0 and HealBot_IsFighting then
    for member,_ in pairs(HealBot_UnitBuff) do
      local unit=HealBot_UnitID[member];
      HealBot_UnitBuff[member]=nil
      if unit then
        HealBot_DelayBuffCheck[unit]=true;
      end
    end
    HealBot_DelayBuffCheck["player"]=true;
  end
    
  if HealBot_Config.DebuffWatch==1 and HealBot_Config.DebuffWatchInCombat==0 and HealBot_IsFighting then
    for member,_ in pairs(HealBot_UnitDebuff) do
      local unit=HealBot_UnitID[member];
      HealBot_UnitDebuff[member]=nil
      if unit then
        HealBot_DelayDebuffCheck[unit]=true;
      end
    end
    HealBot_DelayDebuffCheck["player"]=true;
  end
	
  HealBot_Action_SetHeightWidth(OffsetX, MaxOffsetY+10, bwidth);
  HealBot_Action_RefreshButtons();
  if HealBot_Config.bar2size[HealBot_Config.Current_Skin]>0 then HealBot_Action_RefreshAllBar3(); end
else
  Delay_RecalcParty=3;
end
end

function HealBot_Action_Reset()
  HealBot_Action:ClearAllPoints();
  HealBot_Action:SetPoint("TOP","MinimapCluster","BOTTOM",7,10);
  HealBot_Action_HealTarget = {};
  HealBot_Action_PartyChanged();
end

function HealBot_Action_ClassColour(class)
  local ClassColourR,ClassColourG,ClassColourB = 0,1,0;
  if class==HEALBOT_DRUID then
    ClassColourR,ClassColourG,ClassColourB = 1.0,0.49,0.04;
  elseif class==HEALBOT_HUNTER then
    ClassColourR,ClassColourG,ClassColourB = 0.67,0.83,0.45;
  elseif class==HEALBOT_MAGE then
    ClassColourR,ClassColourG,ClassColourB = 0.41,0.8,0.94;
  elseif class==HEALBOT_PALADIN then
    ClassColourR,ClassColourG,ClassColourB = 0.96,0.55,0.73;
  elseif class==HEALBOT_PRIEST then
    ClassColourR,ClassColourG,ClassColourB = 1.0,1.0,1.0;
  elseif class==HEALBOT_ROGUE then
    ClassColourR,ClassColourG,ClassColourB = 1.0,0.96,0.41;
  elseif class==HEALBOT_SHAMAN then
    ClassColourR,ClassColourG,ClassColourB = 0.96,0.55,0.73;
  elseif class==HEALBOT_WARLOCK then
    ClassColourR,ClassColourG,ClassColourB = 0.58,0.51,0.79;
  elseif class==HEALBOT_WARRIOR then
    ClassColourR,ClassColourG,ClassColourB = 0.78,0.61,0.43;
  end
  return ClassColourR,ClassColourG,ClassColourB;
end

function HealBot_Action_RefreshTooltip(unit)
  if HealBot_Config.ShowTooltip==0 then return end
  if not unit then return end;
  
  local Member_Name=UnitName(unit);
  if (not Member_Name) then return nil end;

  if HealBot_Config.ProtectPvP==1 and UnitIsPVP(unit) and not UnitIsPVP("player") then return nil end
  
  local hlth=UnitHealth(unit);
  local maxhlth=UnitHealthMax(unit);

  local spellLeft = HealBot_Action_SpellPattern("Left");
  local spellMiddle = HealBot_Action_SpellPattern("Middle");
  local spellRight = HealBot_Action_SpellPattern("Right");
  local spellButton4 = HealBot_Action_SpellPattern("Button4");
  local spellButton5 = HealBot_Action_SpellPattern("Button5");
  local linenum = 1
  
  if not IsModifierKeyDown() and not HealBot_IsFighting and HealBot_Config.SmartCast==1 then 
    local templeft=spellLeft;
    spellLeft=nil;
    spellLeft=HealBot_Action_SmartCast(unit);
    if not spellLeft then spellLeft=templeft; end;
  end
  if spellLeft~=HEALBOT_DISABLED_TARGET and spellLeft~=HEALBOT_ASSIST and spellLeft~=HEALBOT_FOCUS then
    
    if spellLeft then
      local id;
      if not HealBot_Spells[spellLeft] then
        id = HealBot_GetSpellId(spellLeft);
      elseif HealBot_Spells[spellLeft].id then
        id = HealBot_Spells[spellLeft].id
      else
        id = HealBot_GetSpellId(spellLeft);
      end
      local lspell, lspellrank = HealBot_GetSpellName(id)
      if lspellrank then
        spellLeft=lspell .. "(" .. lspellrank .. ")";
      else
        spellLeft=lspell;
      end
    else 
      spellLeft = HealBot_GetHealSpell(unit,HealBot_Action_SpellPattern("Left"));
    end
  end
  if spellMiddle~=HEALBOT_DISABLED_TARGET and spellMiddle~=HEALBOT_ASSIST and spellMiddle~=HEALBOT_FOCUS then
    spellMiddle = HealBot_GetHealSpell(unit,spellMiddle);
  end
  if spellRight~=HEALBOT_DISABLED_TARGET and spellRight~=HEALBOT_ASSIST and spellRight~=HEALBOT_FOCUS then
    spellRight = HealBot_GetHealSpell(unit,spellRight);
  end
  if spellButton4~=HEALBOT_DISABLED_TARGET and spellButton4~=HEALBOT_ASSIST and spellButton4~=HEALBOT_FOCUS then
    spellButton4 = HealBot_GetHealSpell(unit,spellButton4);
  end
  if spellButton5~=HEALBOT_DISABLED_TARGET and spellButton5~=HEALBOT_ASSIST and spellButton5~=HEALBOT_FOCUS then
    spellButton5 = HealBot_GetHealSpell(unit,spellButton5);
  end
  
  HealBot_Action_Tooltip_ClearLines();
    
  if HealBot_Config.Tooltip_ShowTarget==1 then
    if Member_Name then
      if HealBot_UnitClass[Member_Name] and HealBot_UnitLevel[Member_Name] then
        HealBot_Action_Tooltip_SetLineLeft(Member_Name.." (Level "..HealBot_UnitLevel[Member_Name].." "..HealBot_UnitClass[Member_Name]..")",ClassColR[Member_Name],ClassColG[Member_Name],ClassColB[Member_Name],linenum,1)   
      else 
        HealBot_Action_Tooltip_SetLineLeft(Member_Name,1,1,1,linenum,1)   
      end      
      if hlth and maxhlth then
        local r,g,b,a=HealBot_HealthColor(unit,hlth,maxhlth,true,Member_Name);
        HealBot_Action_Tooltip_SetLineRight(hlth.."/"..maxhlth.." (-"..maxhlth-hlth..")",r,g,b,linenum,1) 
      end
      local DebuffType=HealBot_UnitDebuff[Member_Name];
      if HealBot_UnitDebuff[Member_Name] then
        linenum=linenum+1
        HealBot_Action_Tooltip_SetLineLeft(Member_Name.." suffers from "..HealBot_UnitDebuff[Member_Name.."_debuff_name"],
                                           HealBot_Config.CDCBarColour[DebuffType].R+0.2,
                                           HealBot_Config.CDCBarColour[DebuffType].G+0.2,
                                           HealBot_Config.CDCBarColour[DebuffType].B+0.2,
                                           linenum,1)
      end
      local Member_Buff=HealBot_UnitBuff[Member_Name];
      if Member_Buff then
        linenum=linenum+1
        HealBot_Action_Tooltip_SetLineLeft(Member_Name.." is missing buff "..Member_Buff,
                                           HealBot_buffbarcolr[Member_Buff],
                                           HealBot_buffbarcolg[Member_Buff],
                                           HealBot_buffbarcolb[Member_Buff],
                                           linenum,1)
      end
      linenum=linenum+1;
    end
  else
    HealBot_Action_Tooltip_SetLineLeft(HEALBOT_OPTIONS_TAB_SPELLS,1,1,1,linenum,1)
  end
  
  local spellLeftRecInstant=false;
  local spellMiddleRecInstant=false;
  local spellRightRecInstant=false;
  local spellButton4RecInstant=false;
  local spellButton5RecInstant=false;
  
  if spellLeft=="" then spellLeft=nil; end
  if spellMiddle=="" then spellMiddle=nil; end
  if spellRight=="" then spellRight=nil; end
  if spellButton4=="" then spellButton4=nil; end
  if spellButton5=="" then spellButton5=nil; end
    
    if HealBot_Config.Tooltip_ShowSpellDetail==1 then

      if spellLeft then
        linenum=linenum+1
        HealBot_Action_Tooltip_SetLineLeft(HEALBOT_OPTIONS_BUTTONLEFT.." "..HEALBOT_OPTIONS_COMBOBUTTON..": "..spellLeft,1,1,0,linenum,1) 
        linenum=HealBot_Action_Tooltip_SpellInfo(spellLeft,linenum);
        spellLeftRecInstant=HealBot_Action_Tooltip_CheckForInstant(unit,spellLeft)
        linenum=linenum+1;
      end
      if spellMiddle then
        linenum=linenum+1;
        HealBot_Action_Tooltip_SetLineLeft(HEALBOT_OPTIONS_BUTTONMIDDLE.." "..HEALBOT_OPTIONS_COMBOBUTTON..": "..spellMiddle,1,1,0,linenum,1) 
        linenum=HealBot_Action_Tooltip_SpellInfo(spellMiddle,linenum);
        spellMiddleRecInstant=HealBot_Action_Tooltip_CheckForInstant(unit,spellMiddle)
        linenum=linenum+1;
      end
      if spellRight then
        linenum=linenum+1;
        HealBot_Action_Tooltip_SetLineLeft(HEALBOT_OPTIONS_BUTTONRIGHT.." "..HEALBOT_OPTIONS_COMBOBUTTON..": "..spellRight,1,1,0,linenum,1) 
        linenum=HealBot_Action_Tooltip_SpellInfo(spellRight,linenum);
        spellRightRecInstant=HealBot_Action_Tooltip_CheckForInstant(unit,spellRight)
        linenum=linenum+1;
      end
      if spellButton4 then
        linenum=linenum+1;
        HealBot_Action_Tooltip_SetLineLeft(HEALBOT_OPTIONS_BUTTON4.." "..HEALBOT_OPTIONS_COMBOBUTTON..": "..spellButton4,1,1,0,linenum,1) 
        linenum=HealBot_Action_Tooltip_SpellInfo(spellButton4,linenum);
        spellButton4RecInstant=HealBot_Action_Tooltip_CheckForInstant(unit,spellButton4)
        linenum=linenum+1;
      end
      if spellButton5 then
        linenum=linenum+1;
        HealBot_Action_Tooltip_SetLineLeft(HEALBOT_OPTIONS_BUTTON5.." "..HEALBOT_OPTIONS_COMBOBUTTON..": "..spellButton5,1,1,0,linenum,1) 
        linenum=HealBot_Action_Tooltip_SpellInfo(spellButton5,linenum);
        spellButton5RecInstant=HealBot_Action_Tooltip_CheckForInstant(unit,spellButton5);
        linenum=linenum+1;
      end
    else
      local hlthdelta=maxhlth-hlth;
      local spellLeftTxt, spellLeftHeal, spellLeftR, spellLeftG, spellLeftB, spellLeftA="",0,1,1,1,1;
      local spellMiddleTxt, spellMiddleHeal, spellMiddleR, spellMiddleG, spellMiddleB, spellMiddleA="",0,1,1,1,1;
      local spellRightTxt, spellRightHeal, spellRightR, spellRightG, spellRightB, spellRightA="",0,1,1,1,1;
      local spellButton4Txt, spellButton4Heal, spellButton4R, spellButton4G, spellButton4B, spellButton4A="",0,1,1,1,1;
      local spellButton5Txt, spellButton5Heal, spellButton5R, spellButton5G, spellButton5B, spellButton5A="",0,1,1,1,1;
      local tmpnum=0;
      if spellLeft then 
        spellLeftTxt, spellLeftHeal=HealBot_Action_Tooltip_SpellSummary(spellLeft);
        spellLeftR,spellLeftG,spellLeftB,spellLeftA,spellLeftRecInstant,spellLeftHeal=HealBot_Action_Tooltip_SetQuickTipsColours(spellLeftHeal,hlthdelta,unit,spellLeft)
      end
      if spellMiddle then
        spellMiddleTxt, spellMiddleHeal=HealBot_Action_Tooltip_SpellSummary(spellMiddle);
        spellMiddleR,spellMiddleG,spellMiddleB,spellMiddleA,spellMiddleRecInstant,spellMiddleHeal=HealBot_Action_Tooltip_SetQuickTipsColours(spellMiddleHeal,hlthdelta,unit,spellMiddle)
      end
      if spellRight then
        spellRightTxt, spellRightHeal=HealBot_Action_Tooltip_SpellSummary(spellRight);
        spellRightR,spellRightG,spellRightB,spellRightA,spellRightRecInstant,spellRightHeal=HealBot_Action_Tooltip_SetQuickTipsColours(spellRightHeal,hlthdelta,unit,spellRight)
      end
      if spellButton4 then
        spellButton4Txt, spellButton4Heal=HealBot_Action_Tooltip_SpellSummary(spellButton4);
        spellButton4R,spellButton4G,spellButton4B,spellButton4A,spellButton4RecInstant,spellButton4Heal=HealBot_Action_Tooltip_SetQuickTipsColours(spellButton4Heal,hlthdelta,unit,spellButton4)
      end
      if spellButton5 then
        spellButton5Txt, spellButton5Heal=HealBot_Action_Tooltip_SpellSummary(spellButton5);
        spellButton5R,spellButton5G,spellButton5B,spellButton5A,spellButton5RecInstant,spellButton5Heal=HealBot_Action_Tooltip_SetQuickTipsColours(spellButton5Heal,hlthdelta,unit,spellButton5)
      end
      
      if spellLeft then 
        linenum=linenum+1
        HealBot_Action_Tooltip_SetLineLeft(HEALBOT_OPTIONS_BUTTONLEFT..":",1,1,0,linenum,spellLeftA) 
        HealBot_Action_Tooltip_SetLineRight(spellLeftTxt,spellLeftR,spellLeftG,spellLeftB,linenum,spellLeftA) 
      end
      if spellMiddle then 
        linenum=linenum+1
        HealBot_Action_Tooltip_SetLineLeft(HEALBOT_OPTIONS_BUTTONMIDDLE..":",1,1,0,linenum,spellMiddleA) 
        HealBot_Action_Tooltip_SetLineRight(HealBot_Action_Tooltip_SpellSummary(spellMiddle),spellMiddleR,spellMiddleG,spellMiddleB,linenum,spellMiddleA) 
      end
      if spellRight then 
        linenum=linenum+1
        HealBot_Action_Tooltip_SetLineLeft(HEALBOT_OPTIONS_BUTTONRIGHT..":",1,1,0,linenum,spellRightA) 
        HealBot_Action_Tooltip_SetLineRight(HealBot_Action_Tooltip_SpellSummary(spellRight),spellRightR,spellRightG,spellRightB,linenum,spellRightA) 
      end
      if spellButton4 then 
        linenum=linenum+1
        HealBot_Action_Tooltip_SetLineLeft(HEALBOT_OPTIONS_BUTTON4..":",1,1,0,linenum,spellButton4A) 
        HealBot_Action_Tooltip_SetLineRight(HealBot_Action_Tooltip_SpellSummary(spellButton4),spellButton4R,spellButton4G,spellButton4B,linenum,spellButton4A) 
      end
      if spellButton5 then 
        linenum=linenum+1
        HealBot_Action_Tooltip_SetLineLeft(HEALBOT_OPTIONS_BUTTON5..":",1,1,0,linenum,spellButton5A) 
        HealBot_Action_Tooltip_SetLineRight(HealBot_Action_Tooltip_SpellSummary(spellButton5),spellButton5R,spellButton5G,spellButton5B,linenum,spellButton5A) 
      end
    end      
    if HealBot_Config.Tooltip_Recommend==1 then
      local Instant_check=false;
      if HealBot_Config.Tooltip_ShowSpellDetail==0 then linenum=linenum+1; end
      linenum=linenum+1
      HealBot_Action_Tooltip_SetLineLeft(HEALBOT_TOOLTIP_RECOMMENDTEXT,0.8,0.8,0,linenum,1) 
      if spellLeftRecInstant then
        linenum=linenum+1;
        HealBot_Action_Tooltip_SetLineLeft("   "..HEALBOT_OPTIONS_BUTTONLEFT..":",1,1,0.2,linenum,1);
        HealBot_Action_Tooltip_SetLineRight(spellLeft.."    ",1,1,1,linenum,1);
        Instant_check=true;
      end
      if spellMiddleRecInstant then
        linenum=linenum+1;
        HealBot_Action_Tooltip_SetLineLeft("   "..HEALBOT_OPTIONS_BUTTONMIDDLE..":",1,1,0.2,linenum,1);
        HealBot_Action_Tooltip_SetLineRight(spellMiddle.."    ",1,1,1,linenum,1);
        Instant_check=true;
      end
      if spellRightRecInstant then
        linenum=linenum+1;
        HealBot_Action_Tooltip_SetLineLeft("   "..HEALBOT_OPTIONS_BUTTONRIGHT..":",1,1,0.2,linenum,1);
        HealBot_Action_Tooltip_SetLineRight(spellRight.."    ",1,1,1,linenum,1);
        Instant_check=true;
      end
      if spellButton4RecInstant then
        linenum=linenum+1;
        HealBot_Action_Tooltip_SetLineLeft("   "..HEALBOT_OPTIONS_BUTTON4..":",1,1,0.2,linenum,1);
        HealBot_Action_Tooltip_SetLineRight(spellButton4.."    ",1,1,1,linenum,1);
        Instant_check=true;
      end
      if spellButton5RecInstant then
        linenum=linenum+1;
        HealBot_Action_Tooltip_SetLineLeft("   "..HEALBOT_OPTIONS_BUTTON5..":",1,1,0.2,linenum,1);
        HealBot_Action_Tooltip_SetLineRight(spellButton5.."    ",1,1,1,linenum,1);
        Instant_check=true;
      end
      if not Instant_check then
        linenum=linenum+1
        HealBot_Action_Tooltip_SetLineLeft("  None",0.4,0.4,0.4,linenum,1) 
      end
    else
      if HealBot_Config.Tooltip_ShowSpellDetail==1 then linenum=linenum-1; end
    end

    local height = 20 
    local width = 0
    for i = 1, linenum do
      local txtL = getglobal("HealBot_TooltipTextL" .. i)
      local txtR = getglobal("HealBot_TooltipTextR" .. i)
      height = height + txtL:GetHeight() + 2
      if (txtL:GetWidth() + txtR:GetWidth() + 25 > width) then
        width = txtL:GetWidth() + txtR:GetWidth() + 25
      end
    end
    HealBot_Action_SetTooltipPos();
    HealBot_Tooltip:SetWidth(width)
    HealBot_Tooltip:SetHeight(height)
    HealBot_Tooltip:Show();
end

function HealBot_Action_Tooltip_SpellInfo(spell,linenum)
  local text
  if HealBot_Spells[spell] then
    if HealBot_Spells[spell].HealsDur>0 then
      linenum=linenum+1
      HealBot_Action_Tooltip_SetLineLeft(HEALBOT_WORDS_CAST..": "..HealBot_Spells[spell].CastTime.." "..HEALBOT_WORDS_SEC..".",0.8,0.8,0.8,linenum,1)
      if HealBot_InnerFocus then
        HealBot_Action_Tooltip_SetLineRight("Mana: 0",0.5,0.5,1,linenum,1) 
      else
        HealBot_Action_Tooltip_SetLineRight("Mana: "..HealBot_Spells[spell].Mana,0.5,0.5,1,linenum,1) 
      end
      if HealBot_Spells[spell].HealsMax>0 then
        local Heals = HEALBOT_HEAL.." "
        if HealBot_Spells[spell].Shield then
          Heals = HEALBOT_TOOLTIP_SHIELD.." "
          text=Heals..format("%d", HealBot_Spells[spell].HealsMax)
        else
          if HealBot_Spells[spell].HealsMin<HealBot_Spells[spell].HealsMax then
            text=Heals..format("%d", HealBot_Spells[spell].HealsMin + HealBot_Spells[spell].RealHealing) .." "..HEALBOT_WORDS_TO.." "..format("%d",HealBot_Spells[spell].HealsMax + HealBot_Spells[spell].RealHealing)
          else
            text=Heals..format("%d", HealBot_Spells[spell].HealsMax + HealBot_Spells[spell].RealHealing)
          end
        end
        linenum=linenum+1
        HealBot_Action_Tooltip_SetLineLeft(text,1,1,1,linenum,1)
      end
      if HealBot_Spells[spell].HealsExt>0 then
        text=HEALBOT_HEAL.." "..HealBot_Spells[spell].HealsDur.." "..HEALBOT_WORDS_OVER.." "..HealBot_Spells[spell].Duration-HealBot_Spells[spell].CastTime.." sec."
        linenum=linenum+1
        HealBot_Action_Tooltip_SetLineLeft(text,1,1,1,linenum,1)
      end
      if not HealBot_Spells[spell].Shield then
        text=HEALBOT_TOOLTIP_ITEMBONUS.." +"..HealBot_HealingBonus.." | "..HEALBOT_TOOLTIP_ACTUALBONUS.." +"..HealBot_Spells[spell].RealHealing.." "
        linenum=linenum+1
        HealBot_Action_Tooltip_SetLineLeft(text,0.8,0.8,0.8,linenum,1)
      end
    end
  elseif HealBot_OtherSpells[spell] then
    linenum=linenum+1
    HealBot_Action_Tooltip_SetLineLeft(HEALBOT_WORDS_CAST..": "..HealBot_OtherSpells[spell].CastTime.." "..HEALBOT_WORDS_SEC..".",0.8,0.8,0.8,linenum,1) 
    HealBot_Action_Tooltip_SetLineRight("Mana: "..HealBot_OtherSpells[spell].Mana,0.5,0.5,1,linenum,1)    
  end
  return linenum
end

function HealBot_Action_Tooltip_SpellSummary(spell)
  local ret_val, ret_heal = "  ", 0;
  if HealBot_Spells[spell] then
    if not HealBot_Spells[spell].HealsDur then
      HealBot_AddDebug("HealBot_Action_Tooltip_SpellSummary not HealBot_Spells[spell].HealsDur for "..spell);
    end
    if HealBot_Spells[spell].HealsDur>0 then
      if HealBot_Spells[spell].HealsMax>0 then
        local Heals = " "..HEALBOT_HEAL.." ";
        if HealBot_Spells[spell].Shield then
          Heals = " "..HEALBOT_TOOLTIP_SHIELD.." ";
          ret_heal=HealBot_Spells[spell].HealsMax;
          ret_val=ret_val..Heals..format("%d", ret_heal);
          ret_heal=0-ret_heal;
        else
          if HealBot_Spells[spell].HealsMin<HealBot_Spells[spell].HealsMax then
            ret_heal=((HealBot_Spells[spell].HealsMin+HealBot_Spells[spell].HealsMax)/2) + HealBot_Spells[spell].RealHealing
          else
            ret_heal=HealBot_Spells[spell].HealsMax + HealBot_Spells[spell].RealHealing;
          end
          ret_val=ret_val..Heals..format("%d", ret_heal);
        end
      end
      if HealBot_Spells[spell].HealsExt>0 then
        ret_heal=HealBot_Spells[spell].HealsDur;
        ret_val=ret_val.." HoT "..format("%d", ret_heal);
        ret_heal=0-ret_heal;
      end
--      ret_val=ret_val.." "..HEALBOT_WORDS_FOR.." "..HealBot_Spells[spell].Mana.." Mana";
    end
  elseif HealBot_OtherSpells[spell] then
    if HealBot_InnerFocus then
      ret_val = " - "..spell.."   0 Mana"
    else
      ret_val = " - "..spell.."   "..HealBot_OtherSpells[spell].Mana.." Mana"
    end
  else
    ret_heal=-1;
  end
  if string.len(ret_val)<5 then ret_val = " - "..spell; end
  return ret_val,ret_heal;
end

function HealBot_Action_Tooltip_CheckForInstant(unit,spell)
  if HealBot_Spells[spell] then
    if HealBot_Spells[spell].Buff then
      if HealBot_UnitAffected(unit,HealBot_Spells[spell].Buff) then return false end;  
      return true;
    end
  end
  return false;
end

function HealBot_Action_Tooltip_SetQuickTipsColours(healval,hlthdelta,unit,spell)
  local R,G,B,A,ri=1,1,1,1,false;
  ri=HealBot_Action_Tooltip_CheckForInstant(unit,spell)
  if healval==-1 then
    R, G, B=0.58,0.58,1;
  elseif healval>0 then
    if healval>hlthdelta then
      tmpnum=(healval-hlthdelta);
      A=(hlthdelta-tmpnum)/(hlthdelta+1);
    else
      A=((healval)/(hlthdelta+1))*1.25;
    end
  elseif healval==0 then
    R, G, B=0.8,1,0.2;
  else
    healval=0-healval;
    if (healval*.72)>hlthdelta then
      tmpnum=((healval)-hlthdelta);
      A=((hlthdelta-tmpnum)/(hlthdelta+1))*1.25;
    else
      A=(healval/(hlthdelta+1))*1.5;
    end
    if not ri then
      A=0.2
    end
  end
  if A<0.2 then 
    A=0.2;
  elseif A>1 then 
    A=1;
  end
  return R,G,B,A,ri,healval;
end

function HealBot_Action_RefreshDisabledTooltip(unit)
  if HealBot_Config.ShowTooltip==0 then return end
  if not unit then return end;
  
  local Member_Name=UnitName(unit);

  if (not Member_Name) then return nil end;
  if HealBot_Config.ProtectPvP==1 and UnitIsPVP(unit) and not UnitIsPVP("player") then return nil end
  local combo=HealBot_Config.DisKeyCombo[HealBot_PlayerClass];
  local linenum=1;
  local ModKey="";
  if IsShiftKeyDown() then ModKey="Shift"; end
  if IsControlKeyDown() then ModKey="Ctrl"; end
  if IsAltKeyDown() then ModKey="Alt"; end
 
  local spellLeft
  local spellMiddle = combo[ModKey.."Middle"];
  local spellRight = combo[ModKey.."Right"];
  local spell4 = combo[ModKey.."Button4"];
  local spell5 = combo[ModKey.."Button5"];
  
  local spellLeftRecInstant=false;
  local spellMiddleRecInstant=false;
  local spellRightRecInstant=false;
  local spellButton4RecInstant=false;
  local spellButton5RecInstant=false;
  
  if ModKey=="" and not HealBot_IsFighting and HealBot_Config.SmartCast==1 then 
    spellLeft=HealBot_Action_SmartCast(unit);
  end
  if not spellLeft then
    spellLeft = combo[ModKey.."Left"];
    if spellLeft~=HEALBOT_DISABLED_TARGET and spellLeft~=HEALBOT_ASSIST and spellLeft~=HEALBOT_FOCUS then
      spellLeft = HealBot_GetHealSpell(unit,spellLeft); 
    end
  end
  if spellMiddle~=HEALBOT_DISABLED_TARGET and spellMiddle~=HEALBOT_ASSIST and spellMiddle~=HEALBOT_FOCUS then
    spellMiddle = HealBot_GetHealSpell(unit,spellMiddle);
  end
  if spellRight~=HEALBOT_DISABLED_TARGET and spellRight~=HEALBOT_ASSIST and spellRight~=HEALBOT_FOCUS then
    spellRight = HealBot_GetHealSpell(unit,spellRight);
  end
  if spell4~=HEALBOT_DISABLED_TARGET and spell4~=HEALBOT_ASSIST and spell4~=HEALBOT_FOCUS then
    spell4 = HealBot_GetHealSpell(unit,spell4);
  end
  if spell5~=HEALBOT_DISABLED_TARGET and spell5~=HEALBOT_ASSIST and spell5~=HEALBOT_FOCUS then
    spell5 = HealBot_GetHealSpell(unit,spell5);
  end
  
  local ManaLeft = 0;
  local ManaMiddle = 0;
  local ManaRight = 0;
  local Mana4 = 0;
  local Mana5 = 0;
  
  if HealBot_Spells[spellLeft] then
    ManaLeft = HealBot_Spells[spellLeft].Mana
  elseif HealBot_OtherSpells[spellLeft] then
    ManaLeft = HealBot_OtherSpells[spellLeft].Mana
  elseif spellLeft=="" then
    spellLeft=nil;
  end
    
  if HealBot_Spells[spellMiddle] then
    ManaMiddle = HealBot_Spells[spellMiddle].Mana
  elseif HealBot_OtherSpells[spellMiddle] then
    ManaMiddle = HealBot_OtherSpells[spellMiddle].Mana
  elseif spellMiddle=="" then
    spellMiddle=nil;
  end

  if HealBot_Spells[spellRight] then
    ManaRight = HealBot_Spells[spellRight].Mana
  elseif HealBot_OtherSpells[spellRight] then
    ManaRight = HealBot_OtherSpells[spellRight].Mana
  elseif spellRight=="" then
    spellRight=nil;
  end

  if HealBot_Spells[spell4] then
    ManaRight = HealBot_Spells[spell4].Mana
  elseif HealBot_OtherSpells[spell4] then
    ManaRight = HealBot_OtherSpells[spell4].Mana
  elseif spell4=="" then
    spell4=nil;
  end

  if HealBot_Spells[spell5] then
    ManaRight = HealBot_Spells[spell5].Mana
  elseif HealBot_OtherSpells[spell5] then
    ManaRight = HealBot_OtherSpells[spell5].Mana
  elseif spell5=="" then
    spell5=nil;
  end
    
  HealBot_Action_Tooltip_ClearLines();
  
  if HealBot_Config.Tooltip_ShowTarget==1 then
    local raidID=nil
    local zone=nil;
    if HealBot_PlayerName==Member_Name then
      zone=GetRealZoneText();
    elseif GetNumRaidMembers()>0 then
      if strsub(unit,1,4)~="raid" then
        if UnitInRaid(unit) then
          for r=1,40 do
            if UnitName("raid"..r)==Member_Name then
              raidID=r
              _, _, _, _, _, _, zone, _, _ = GetRaidRosterInfo(raidID);
              do break end;
            end
          end
        end
      elseif strsub(unit,1,7)~="raidpet" then
        raidID=tonumber(strsub(unit,5))
        _, _, _, _, _, _, zone, _, _ = GetRaidRosterInfo(raidID);
      end
    elseif unit~="target" then
      HealBot_TooltipInit();
      HealBot_ScanTooltip:SetUnit(unit)
      zone = HealBot_ScanTooltipTextLeft3:GetText()
      if zone == "PvP" then
        zone = HealBot_ScanTooltipTextLeft4:GetText()
      end
    end
    if Member_Name then
      HealBot_Action_Tooltip_SetLineLeft(Member_Name,ClassColR[Member_Name],ClassColG[Member_Name],ClassColB[Member_Name],linenum,1)
      if HealBot_UnitClass[Member_Name] and HealBot_UnitLevel[Member_Name] then
        HealBot_Action_Tooltip_SetLineRight(" Level "..HealBot_UnitLevel[Member_Name].." "..HealBot_UnitClass[Member_Name],ClassColR[Member_Name],ClassColG[Member_Name],ClassColB[Member_Name],linenum,1);
      end
      if zone then
        linenum=linenum+1
        HealBot_Action_Tooltip_SetLineLeft(HEALBOT_TOOLTIP_LOCATION..":",1,1,0.5,linenum,1);
        HealBot_Action_Tooltip_SetLineRight(zone,1,1,1,linenum,1);
      end
      local DebuffType=HealBot_UnitDebuff[Member_Name];
      if DebuffType then
        linenum=linenum+1
        HealBot_Action_Tooltip_SetLineLeft(Member_Name.." suffers from "..HealBot_UnitDebuff[Member_Name.."_debuff_name"],
                                           HealBot_Config.CDCBarColour[DebuffType].R+0.2,
                                           HealBot_Config.CDCBarColour[DebuffType].G+0.2,
                                           HealBot_Config.CDCBarColour[DebuffType].B+0.2,
                                           linenum,1)
      end
      local Member_Buff=HealBot_UnitBuff[Member_Name];
      if Member_Buff then
        linenum=linenum+1
        HealBot_Action_Tooltip_SetLineLeft(Member_Name.." is missing buff "..Member_Buff,
                                           HealBot_buffbarcolr[Member_Buff],
                                           HealBot_buffbarcolg[Member_Buff],
                                           HealBot_buffbarcolb[Member_Buff],
                                           linenum,1)
      end
      linenum=linenum+1
    end
  else
    HealBot_Action_Tooltip_SetLineLeft(HEALBOT_OPTIONS_TAB_SPELLS,1,1,1,linenum,1)
  end
  
  if spellLeft then
    linenum=linenum+1
    HealBot_Action_Tooltip_SetLineLeft(HEALBOT_OPTIONS_BUTTONLEFT..": "..spellLeft,1,1,0,linenum,1) 
    if ManaLeft>0 then 
      if HealBot_InnerFocus then ManaLeft=0; end
      HealBot_Action_Tooltip_SetLineRight("  "..ManaLeft.." Mana",0.5,0.5,1,linenum,1); 
    end
    spellLeftRecInstant=HealBot_Action_Tooltip_CheckForInstant(unit,spellLeft)
  end
  if spellMiddle then
    linenum=linenum+1
    HealBot_Action_Tooltip_SetLineLeft(HEALBOT_OPTIONS_BUTTONMIDDLE..": "..spellMiddle,1,1,0,linenum,1) 
    if ManaMiddle>0 then
      if HealBot_InnerFocus then ManaMiddle=0; end
      HealBot_Action_Tooltip_SetLineRight("  "..ManaMiddle.." Mana",0.5,0.5,1,linenum,1); 
    end
    spellMiddleRecInstant=HealBot_Action_Tooltip_CheckForInstant(unit,spellMiddle)
  end
  if spellRight then
    linenum=linenum+1
    HealBot_Action_Tooltip_SetLineLeft(HEALBOT_OPTIONS_BUTTONRIGHT..": "..spellRight,1,1,0,linenum,1) 
    if ManaRight>0 then 
      if HealBot_InnerFocus then ManaRight=0; end
      HealBot_Action_Tooltip_SetLineRight("  "..ManaRight.." Mana",0.5,0.5,1,linenum,1); 
    end
    spellRightRecInstant=HealBot_Action_Tooltip_CheckForInstant(unit,spellRight)
  end
  if spell4 then
    linenum=linenum+1
    HealBot_Action_Tooltip_SetLineLeft(HEALBOT_OPTIONS_BUTTON4..": "..spell4,1,1,0,linenum,1) 
    if Mana4>0 then 
      if HealBot_InnerFocus then Mana4=0; end
      HealBot_Action_Tooltip_SetLineRight("  "..Mana4.." Mana",0.5,0.5,1,linenum,1); 
    end
    spellButton4RecInstant=HealBot_Action_Tooltip_CheckForInstant(unit,spell4)
  end
  if spell5 then
    linenum=linenum+1
    HealBot_Action_Tooltip_SetLineLeft(HEALBOT_OPTIONS_BUTTON5..": "..spell5,1,1,0,linenum,1) 
    if Mana5>0 then 
      if HealBot_InnerFocus then Mana5=0; end
      HealBot_Action_Tooltip_SetLineRight("  "..Mana5.." Mana",0.5,0.5,1,linenum,1); 
    end
    spellButton5RecInstant=HealBot_Action_Tooltip_CheckForInstant(unit,spell5);
  end

  if HealBot_Config.Tooltip_Recommend==1 then
    local Instant_check=false;
    linenum=linenum+2
    HealBot_Action_Tooltip_SetLineLeft(HEALBOT_TOOLTIP_RECOMMENDTEXT,0.8,0.8,0,linenum,1) 
      if spellLeftRecInstant then
        linenum=linenum+1;
        HealBot_Action_Tooltip_SetLineLeft("   "..HEALBOT_OPTIONS_BUTTONLEFT..":",1,1,0.2,linenum,1);
        HealBot_Action_Tooltip_SetLineRight(spellLeft.."    ",1,1,1,linenum,1);
        Instant_check=true;
      end
      if spellMiddleRecInstant then
        linenum=linenum+1;
        HealBot_Action_Tooltip_SetLineLeft("   "..HEALBOT_OPTIONS_BUTTONMIDDLE..":",1,1,0.2,linenum,1);
        HealBot_Action_Tooltip_SetLineRight(spellMiddle.."    ",1,1,1,linenum,1);
        Instant_check=true;
      end
      if spellRightRecInstant then
        linenum=linenum+1;
        HealBot_Action_Tooltip_SetLineLeft("   "..HEALBOT_OPTIONS_BUTTONRIGHT..":",1,1,0.2,linenum,1);
        HealBot_Action_Tooltip_SetLineRight(spellRight.."    ",1,1,1,linenum,1);
        Instant_check=true;
      end
      if spellButton4RecInstant then
        linenum=linenum+1;
        HealBot_Action_Tooltip_SetLineLeft("   "..HEALBOT_OPTIONS_BUTTON4..":",1,1,0.2,linenum,1);
        HealBot_Action_Tooltip_SetLineRight(spell4.."    ",1,1,1,linenum,1);
        Instant_check=true;
      end
      if spellButton5RecInstant then
        linenum=linenum+1;
        HealBot_Action_Tooltip_SetLineLeft("   "..HEALBOT_OPTIONS_BUTTON5..":",1,1,0.2,linenum,1);
        HealBot_Action_Tooltip_SetLineRight(spell5.."    ",1,1,1,linenum,1);
        Instant_check=true;
      end
    if not Instant_check then
      linenum=linenum+1
      HealBot_Action_Tooltip_SetLineLeft("  None",0.4,0.4,0.4,linenum,1) 
    end
  end

    local height = 20 
    local width = 0
    for i = 1, linenum do
      local txtL = getglobal("HealBot_TooltipTextL" .. i)
      local txtR = getglobal("HealBot_TooltipTextR" .. i)
      height = height + txtL:GetHeight() + 2
      if (txtL:GetWidth() + txtR:GetWidth() + 25 > width) then
        width = txtL:GetWidth() + txtR:GetWidth() + 25
      end
    end
    HealBot_Action_SetTooltipPos();
    HealBot_Tooltip:SetWidth(width)
    HealBot_Tooltip:SetHeight(height)
    HealBot_Tooltip:Show();
end

function HealBot_Action_SetTooltipPos()
    HealBot_Tooltip:ClearAllPoints();
    if HealBot_Config.TooltipPos>1 then
      local top = HealBot_Action:GetTop();
      local x, y = GetCursorPosition();
      x=x/UIParent:GetScale();
      y=y/UIParent:GetScale();
      if HealBot_Config.TooltipPos==2 then
        HealBot_Tooltip:SetPoint("TOPRIGHT","HealBot_Action","TOPLEFT",0,0-(top-(y+35)));
      elseif HealBot_Config.TooltipPos==3 then
        HealBot_Tooltip:SetPoint("TOPLEFT","HealBot_Action","TOPRIGHT",0,0-(top-(y+35)));
      elseif HealBot_Config.TooltipPos==4 then
        HealBot_Tooltip:SetPoint("BOTTOM","HealBot_Action","TOP",0,0);
      elseif HealBot_Config.TooltipPos==5 then
        HealBot_Tooltip:SetPoint("TOP","HealBot_Action","BOTTOM",0,0);
      else
        HealBot_Tooltip:SetPoint("TOPLEFT","WorldFrame","BOTTOMLEFT",x+25,y-20);
      end
    else
      HealBot_Tooltip:SetPoint("BOTTOMRIGHT","WorldFrame","BOTTOMRIGHT",-105,105);
    end
end

function HealBot_Action_Tooltip_SetLineLeft(Text,R,G,B,linenum,a)
  local txtL = getglobal("HealBot_TooltipTextL" .. linenum)
  txtL:SetTextColor(R,G,B,a)
  txtL:SetText(Text)
  txtL:Show()
end

function HealBot_Action_Tooltip_SetLineRight(Text,R,G,B,linenum,a)
  local txtR = getglobal("HealBot_TooltipTextR" .. linenum)
  txtR:SetTextColor(R,G,B,a)
  txtR:SetText(Text)
  txtR:Show()
end

function HealBot_Action_Tooltip_ClearLines()
  for j=1,34 do
    local txtL = getglobal("HealBot_TooltipTextL" .. j)
    local txtR = getglobal("HealBot_TooltipTextR" .. j)
    txtL:SetText(" ")
    txtR:SetText(" ")
  end
end

function HealBot_Action_ShowTooltip(this)
  if HealBot_Config.ShowTooltip==0 then return end
  if not this.unit then return end;
  
  HealBot_Action_TooltipUnit = this.unit;
  HealBot_Action_DisableTooltipUnit = nil;
  HealBot_Action_RefreshTooltip(this.unit);
end

function HealBot_Action_ShowDisabledTooltip(this)
  if HealBot_Config.ShowTooltip==0 then return end
  if not this.unit then return end;
  
  HealBot_Action_TooltipUnit = nil;
  HealBot_Action_DisableTooltipUnit = this.unit;
  HealBot_Action_RefreshDisabledTooltip(this.unit);
end

function HealBot_Action_HideTooltip(this)
  if HealBot_Config.ShowTooltip==0 then return end
  HealBot_Action_TooltipUnit = nil;
  HealBot_Action_DisableTooltipUnit = nil;
  HealBot_Tooltip:Hide();
end

function HealBot_Action_Refresh(unit)
  if not HealBot_PlayerCanCast or HealBot_PlayerDead then
    if HealBot_Config.AutoClose==1 and HealBot_Config.ActionVisible~=0 then 
      HideUIPanel(HealBot_Action); 
    else
      HealBot_Action_RefreshButtons(unit);
    end
    return;
  end
  HealBot_Action_RefreshButtons(unit);
  if not HealBot_IsFighting then
    if HealBot_Config.ActionVisible==0 then
      if HealBot_Action_ShouldHealSome() then
        ShowUIPanel(HealBot_Action);
      end
    elseif HealBot_Config.AutoClose==1 then 
      if not HealBot_Action_ShouldHealSome() then
        HideUIPanel(HealBot_Action);
      end
    end
  end
end

function HealBot_Action_SpellPattern(button)
  local combos = HealBot_Config.KeyCombo[HealBot_PlayerClass]
  if not combos then return nil end
  local press = button;
  if IsAltKeyDown() then press = "Alt"..press end
  if IsControlKeyDown() then press = "Ctrl"..press end
  if IsShiftKeyDown() then press = "Shift"..press end
  return combos[press]
end

--------------------------------------------------------------------------------------------------
-- Widget_OnFoo functions
--------------------------------------------------------------------------------------------------

function HealBot_Action_HealUnit_OnEnter(this)
  local unit=this.unit;
  if not unit then return; end
  local Member_Name=UnitName(unit);
  if HealBot_IsFighting then
    HealBot_Action_ShowTooltip(this);
  elseif HealBot_Enabled[Member_Name] then 
    HealBot_Action_ShowTooltip(this);
  else
    if (HealBot_PlayerCanCast and not HealBot_PlayerDead) then
      HealBot_Action_ShowDisabledTooltip(this);
    end
  end
end

function HealBot_Action_HealUnit_OnLeave(this)
  HealBot_Action_HideTooltip(this);
end

function HealBot_Action_HealUnitCheck_OnClick(this)
  if not this.unit then return end
  if this:GetChecked() then
    table.insert(HealBot_Action_HealTarget,this.unit)
  else
    for i=1,table.getn(HealBot_Action_HealTarget) do
      if HealBot_Action_HealTarget[i]==this.unit then
        table.remove(HealBot_Action_HealTarget,i);
        break;
      end
    end
  end
  HealBot_Action_PartyChanged();
end

function HealBot_Action_OptionsButton_OnClick(this)
    HealBot_TogglePanel(HealBot_Options);
end

function HealBot_CT_RaidAssist()
  if (type(CT_RA_MemberFrame_OnClick)=="function") then
    HealBot_CT_RA_CustomOnClickFunction_Old = CT_RA_CustomOnClickFunction;
    CT_RA_CustomOnClickFunction = HealBot_CT_RA_CustomOnClickFunction;
  end
end



--------------------------------------------------------------------------------------------------
-- Frame_OnFoo functions
--------------------------------------------------------------------------------------------------

function HealBot_Action_OnLoad(this)
--  HealBot_CT_RaidAssist();
end

function HealBot_Action_OnShow(this)
  if HealBot_Config.PanelSounds==1 then
    PlaySound("igAbilityOpen");
  end
  HealBot_Config.ActionVisible = 1
  HealBot_Action:SetBackdropColor(
    HealBot_Config.backcolr[HealBot_Config.Current_Skin],
    HealBot_Config.backcolg[HealBot_Config.Current_Skin],
    HealBot_Config.backcolb[HealBot_Config.Current_Skin], 
    HealBot_Config.backcola[HealBot_Config.Current_Skin]);
  HealBot_Action:SetBackdropBorderColor(
    HealBot_Config.borcolr[HealBot_Config.Current_Skin],
    HealBot_Config.borcolg[HealBot_Config.Current_Skin],
    HealBot_Config.borcolb[HealBot_Config.Current_Skin],
    HealBot_Config.borcola[HealBot_Config.Current_Skin]);
end

function HealBot_Action_OnHide(this)
  HealBot_StopMoving(this);
  HealBot_Config.ActionVisible = 0
end

function HealBot_Action_OnMouseDown(this,button)
  if button~="RightButton" then
    if HealBot_Config.ActionLocked==0 then
      HealBot_StartMoving(this);
    end
  end
end

function HealBot_Action_OnMouseUp(this,button)
  if button~="RightButton" then
    HealBot_StopMoving(this);
  elseif not HealBot_IsFighting and HealBot_Config.RightButtonOptions~=0 then
    HealBot_Action_OptionsButton_OnClick();
  end
end

function HealBot_Action_OnDragStart(this,button)
  if HealBot_Config.ActionLocked==0 then
    HealBot_StartMoving(this);
  end
end

function HealBot_Action_OnDragStop(this)
  HealBot_StopMoving(this);
end

function HealBot_Action_PreClick(self,button)
 if not HealBot_IsFighting then
  local usedSmartCast=false;
  local unit=self.unit;
  local buttonName=self:GetName();
  if HealBot_Config.ProtectPvP==1 then
    if UnitIsPVP(unit) and not UnitIsPVP("player") then 
      HealBot_Action_SetAttribs(self,"nil")
      HealBot_Prev_State[buttonName]="nil"
      return;
    end
  end
  if button=="LeftButton" and not IsModifierKeyDown() then
    if HealBot_Config.SmartCast==1 then 
      local spell=HealBot_Action_SmartCast(unit);
      if spell then
        local SpellID=HealBot_GetSpellId(spell)
        if SpellID then
	      self:SetAttribute("helpbutton1", "heal1");
          self:SetAttribute("type-heal1", "spell");
          self:SetAttribute("spell-heal1", spell);
        else
	      self:SetAttribute("helpbutton1", "item1");
          self:SetAttribute("type-item1", "item");
          self:SetAttribute("item-item1", spell);
        end
        usedSmartCast=true;
        HealBot_Prev_State[buttonName]="usedSmartCast"
      end
    end
  end
  if not usedSmartCast then
    local Member_Name=UnitName(unit);
    if HealBot_Enabled[Member_Name] then
      if HealBot_Prev_State[buttonName]~="Enabled" then
         HealBot_Prev_State[buttonName]="Enabled"
         HealBot_Action_SetAttribs(self,"Enabled")
      end
    else 
      if HealBot_Prev_State[buttonName]~="Disabled" then
        HealBot_Prev_State[buttonName]="Disabled"
        HealBot_Action_SetAttribs(self,"Disabled")
      end
    end
  end
 end
end

function HealBot_Action_SmartCast(unit)
  local spell
  local Member_Name=UnitName(unit);
  if not HealBot_PlayerCanCast or HealBot_PlayerDead or not Member_Name then return nil; end
  
  if HealBot_Config.SmartCastRes==1 and UnitIsDeadOrGhost(unit) then
   spell=SmartCast_Res;
  elseif HealBot_UnitDebuff[Member_Name] and HealBot_Config.SmartCastDebuff==1 then
    spell=HealBot_DebuffSpell[HealBot_UnitDebuff[Member_Name]];
  elseif HealBot_UnitBuff[Member_Name] and HealBot_Config.SmartCastBuff==1 then
    spell=HealBot_UnitBuff[Member_Name];
  elseif HealBot_Config.SmartCastHeal==1 then
    if not HealBot_HealsIn[Member_Name] then
      HealBot_HealsIn[Member_Name]=0;
    end
    local hlth, maxhlth = HealBot_UnitHealth(unit);
    local hdelta = maxhlth-(hlth+HealBot_HealsIn[Member_Name]);
    if hdelta>5000 then
      spell=SmartCast_Heal[7];
    elseif hdelta>3000 then
      spell=SmartCast_Heal[6];
    elseif hdelta>2000 then
      spell=SmartCast_Heal[5];
    elseif hdelta>1500 then
      spell=SmartCast_Heal[4];
    elseif hdelta>1000 then
      spell=SmartCast_Heal[3];
    elseif hdelta>700 then
      spell=SmartCast_Heal[2];
    elseif hdelta>400 then
      spell=SmartCast_Heal[1];
    end
  end
  if spell and Member_Name~=HealBot_PlayerName then
    if IsSpellInRange(spell, unit)~=1 then return nil; end
  end
  return spell;
end


