Petster = ZubanLib.Object:New{
	_debug = false;
};

function Petster:Debug(message)
	if (self._debug) then
		ZubanLib.IO:Write(tostring(message));
	end
end

function Petster:Write(message)
	ZubanLib.IO:Write("Petster: "..tostring(message));
end

function Petster:Warn(message)
	ZubanLib.IO:Warn("Petster: "..tostring(message));
end

--
-- PetsterMoverTemplate class
--
Petster.MoverTemplate = ZubanLib.Object:New{
	_lockedAlpha = 0.4;
	_normalAlpha = 1;
	_smallScale = 0.6;
	_normalScale = 1;
	SecureAnchor = nil;
	Moved = nil;
};

function Petster.MoverTemplate:Initialize(moverName, movedName)
	self.SecureAnchor = getglobal(moverName);
	self.SecureAnchor.Mover = self;
	self.Moved = getglobal(movedName);
	self.Moved.Mover = self;
end

function Petster.MoverTemplate:OnEnter()
	-- display tooltip
	GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
	
	if (self:GetLocked()) then
		GameTooltip:SetText(PetsterResources.Unlock);
	else
		GameTooltip:SetText(PetsterResources.Drag);
		GameTooltip:AddLine(PetsterResources.Lock, "", 1, 1, 1);
		GameTooltip:AddLine(self:GetRightClickTooltip(), "", 1, 1, 1);
	end
	
	GameTooltip:Show();
end

function Petster.MoverTemplate:GetRightClickTooltip()
	return PetsterResources.Resize;
end

function Petster.MoverTemplate:OnClick(button)
	Petster:Debug("Mover:OnClick");

	if (button == "LeftButton") then
		-- toggle the mover lock
		self:ToggleLock();
		GameTooltip:Hide();
	elseif (button == "RightButton") then
		if (not self:GetLocked()) then
			self:OnRightClick();
		end
	end
end

function Petster.MoverTemplate:OnRightClick()
	self:ToggleSize();
end

function Petster.MoverTemplate:ToggleLock()
	if (self:GetLocked()) then
		self:SetLocked(false);
	else
		self:SetLocked(true);
	end
end

function Petster.MoverTemplate:ToggleSize()
	if (self:GetScale() == self._smallScale) then
		self:SetScale(self._normalScale);
	else
		self:SetScale(self._smallScale);
	end
end

function Petster.MoverTemplate:GetScale()
	return self._normalScale;
end

function Petster.MoverTemplate:SetScale(scale)
	self.SecureAnchor:SetScale(scale);
end

function Petster.MoverTemplate:GetLocked()
	return false;
end

function Petster.MoverTemplate:SetLocked(locked)
	if (not locked) then
		self.SecureAnchor:SetAlpha(self._normalAlpha);
	else
		self.SecureAnchor:SetAlpha(self._lockedAlpha);
	end
end
