PETSTER_OPTIONS_ENABLED = PetsterResources.Options.Enabled;
PETSTER_OPTIONS_SMALL = PetsterResources.Options.Small;
PETSTER_OPTIONS_LOCKED = PetsterResources.Options.Locked;
PETSTER_OPTIONS_WHEELEDIT = PetsterResources.Options.WheelEdit;
PETSTER_OPTIONS_SPACING = PetsterResources.Options.Spacing;
PETSTER_OPTIONS_AWAYBUTTONSLOTS = PetsterResources.Options.AwayButtonSlots;
PETSTER_OPTIONS_PRESENTBUTTONSLOTS = PetsterResources.Options.PresentButtonSlots;
PETSTER_OPTIONS_FEEDHEADER = PetsterResources.Options.FeedHeader;
PETSTER_OPTIONS_BASICHEADER = PetsterResources.Options.BasicHeader;
PETSTER_OPTIONS_EXHEADER = PetsterResources.Options.ExHeader;

--
-- CheckButton class
--
Petster.CheckButton = ZubanLib.Object:New{
	Button = nil;
}

function Petster.CheckButton:LoadFromXml(name)
	self.Button = getglobal(name);
	self.Button.Button = self;
end

function Petster.CheckButton:Click()
	self.Button:Click();
end

function Petster.CheckButton:SetChecked(checked)
	self.Button:SetChecked(checked);
end

function Petster.CheckButton:GetChecked()
	self.Button:GetChecked();
end

--
-- SliderTemplate class
--
Petster.SliderTemplate = ZubanLib.Object:New{
	Slider = nil;
};

function Petster.SliderTemplate:Initialize(sliderName, low, high, step)
	self.Slider = getglobal(sliderName);
	self.Slider.Slider = self;
	
	local lowText = getglobal(self.Slider:GetName().."Low");
	local highText = getglobal(self.Slider:GetName().."High");
	local text = getglobal(self.Slider:GetName().."Text");
	
	lowText:SetText(low);
	highText:SetText(high);
	text:SetText(low);
	self.Slider:SetMinMaxValues(low, high);
	self.Slider:SetValueStep(step);
	self.Slider:SetValue(low);
end

function Petster.SliderTemplate:SetValue(value)
	local text = getglobal(self.Slider:GetName().."Text");
	text:SetText(value);
	self.Slider:SetValue(value);
end

--
-- Options object
--
Petster.Options = ZubanLib.Object:New{
	Frame = nil;
	Feed = {
		Enabled = Petster.CheckButton:New{};
		Size = Petster.CheckButton:New{};
		Locked = Petster.CheckButton:New{};
	};
	Basic = {
		Enabled = Petster.CheckButton:New{};
		Size = Petster.CheckButton:New{};
		Locked = Petster.CheckButton:New{};
	};
	Ex = {
		Enabled = Petster.CheckButton:New{};
		Size = Petster.CheckButton:New{};
		Locked = Petster.CheckButton:New{};
		WheelEditEnabled = Petster.CheckButton:New{};
		SpacingSlider = Petster.SliderTemplate:New{};
		Away = {
			Enabled = {};
			Slot = {};
		};
		Present = {
			Enabled = {};
			Slot = {};
		};
		CurrentSlots = {};
	};
};

function Petster.Options:OnLoad()
	if (not ZubanLib.Unit:IsHunter() and not ZubanLib.Unit:IsWarlock()) then
		return;
	end

	self.Frame = getglobal("PetsterOptionsFrame");
	this:RegisterEvent("VARIABLES_LOADED");

	-- buttons need to be setup before initializing the slider
	self.Ex.SpacingSlider:Initialize(self.Frame:GetName().."ExSpacingSlider", 0, 25, 1);

	self.Feed.Enabled:LoadFromXml(self.Frame:GetName().."FeedEnabled");
	self.Feed.Size:LoadFromXml(self.Frame:GetName().."FeedSize");
	self.Feed.Locked:LoadFromXml(self.Frame:GetName().."FeedLocked");

	self.Basic.Enabled:LoadFromXml(self.Frame:GetName().."BasicEnabled");
	self.Basic.Size:LoadFromXml(self.Frame:GetName().."BasicSize");
	self.Basic.Locked:LoadFromXml(self.Frame:GetName().."BasicLocked");

	self.Ex.Enabled:LoadFromXml(self.Frame:GetName().."ExEnabled");
	self.Ex.Size:LoadFromXml(self.Frame:GetName().."ExSize");
	self.Ex.Locked:LoadFromXml(self.Frame:GetName().."ExLocked");
	self.Ex.WheelEditEnabled:LoadFromXml(self.Frame:GetName().."ExWheelEditEnabled");
end

function Petster.Options:OnVariablesLoaded()
	Petster.Ex:OnVariablesLoaded();
	
	if (Petster.Feed ~= nil) then
		self.Feed.Enabled:SetChecked(PetsterButtonState.Enabled);
		self.Feed.Locked:SetChecked(PetsterButtonState.Locked);
		self.Feed.Size:SetChecked(PetsterButtonState.Scale == Petster.Feed.Mover._smallScale);
	end
end

function Petster.Options:ToggleOptions()
	if (self.Frame:IsShown()) then
		self.Frame:Hide();
	else
		self.Frame:Show();
	end
end

function Petster.Options:Close()
	self.Frame:Hide();
end

function Petster.Options.Feed.Enabled:OnClick(button)
	if (Petster.Feed ~= nil) then
		local checked = this:GetChecked() == 1;
		Petster.Feed:SetEnabled(checked);
	end
end

function Petster.Options.Feed.Size:OnClick(button)
	if (Petster.Feed ~= nil) then
		if (this:GetChecked() == 1) then
			Petster.Feed.Mover:SetScale(Petster.Feed.Mover._smallScale);
		else
			Petster.Feed.Mover:SetScale(Petster.Feed.Mover._normalScale);
		end
	end
end

function Petster.Options.Feed.Locked:OnClick(button)
	if (Petster.Feed ~= nil) then
		local checked = this:GetChecked() == 1;
		Petster.Feed.Mover:SetLocked(checked);
	end
end

function Petster.Options.Basic.Enabled:OnClick(button)
	-- TODO
end

function Petster.Options.Basic.Size:OnClick(button)
	-- TODO
end

function Petster.Options.Basic.Locked:OnClick(button)
	-- TODO
end

function Petster.Options.Ex.Enabled:OnClick(button)
	local checked = this:GetChecked() == 1;
	Petster.Ex:SetEnabled(checked);
end

function Petster.Options.Ex.Size:OnClick(button)
	if (this:GetChecked() == 1) then
		Petster.Ex.Mover:SetScale(Petster.Ex.Mover._smallScale);
	else
		Petster.Ex.Mover:SetScale(Petster.Ex.Mover._normalScale);
	end
end

function Petster.Options.Ex.Locked:OnClick(button)
	local checked = this:GetChecked() == 1;
	Petster.Ex.Mover:SetLocked(checked);
end

function Petster.Options.Ex.WheelEditEnabled:OnClick(button)
	local checked = this:GetChecked() == 1;
	Petster.Ex:SetWheelEdit(checked);
end

function Petster.Options.Ex.WheelEditEnabled:SetText(button, slot)
	-- update the options frame
	local editBoxName = "PetsterOptionsFrameEx"..button.Category.."Slot"..button.Pid;
	local editBox = getglobal(editBoxName);
	editBox:SetText(slot);
end

function Petster.Options.Ex.SpacingSlider:OnValueChanged(value)
	--Petster:Debug("SpacingSlider:OnValueChanged");
	if (self.Slider == nil) then
		return;
	end
	
	self:SetValue(value);
	Petster.Ex:SetSpacing(value);
end

function Petster.Options.Ex.Away.Slot:OnTextChanged()
	local id = this:GetID();
	local slot = this:GetText();
	
	if (slot ~= nil and slot ~= "") then
		Petster:Debug(string.format("id=%s, slot=%s", id, slot));
		Petster.Ex.AwayButtons[id]:SetSlot(slot);
	end
end

function Petster.Options.Ex.Away.Enabled:OnClick(button)
	local id = this:GetID();
	local checked = this:GetChecked() == 1;
	
	Petster.Ex.AwayButtons[id]:SetVisibility(checked);
end

function Petster.Options.Ex.Away.Enabled:SetChecked(button, checked)
	-- update the options frame
	local buttonName = "PetsterOptionsFrameEx"..button.Category.."Enabled"..button.Pid;
	local button = getglobal(buttonName);
	button:SetChecked(checked);
end

function Petster.Options.Ex.Present.Slot:OnTextChanged()
	local id = this:GetID();
	local slot = this:GetText();

	if (slot ~= nil and slot ~= "") then
		Petster:Debug(string.format("id=%s, slot=%s", id, slot));
		Petster.Ex.PresentButtons[id]:SetSlot(slot);
	end
end

function Petster.Options.Ex.Present.Enabled:OnClick(button)
	local id = this:GetID();
	local checked = this:GetChecked() == 1;
	
	Petster.Ex.PresentButtons[id]:SetVisibility(checked);
end

function Petster.Options.Ex.Present.Enabled:SetChecked(button, checked)
	-- update the options frame
	local buttonName = "PetsterOptionsFrameEx"..button.Category.."Enabled"..button.Pid;
	local button = getglobal(buttonName);
	button:SetChecked(checked);
end

function Petster.Options.Ex.CurrentSlots:OnShow()
	ZubanLib.Action:ForEachSlotNameRank(
		function(slot, name, rank)
			if (name ~= nil and name ~= "") then
				this:AddMessage(string.format("|cFFFFFFFF%s: |r%s", tostring(slot), tostring(name)));
			end
		end
	);
end