--[[
	SpellTips 0.98 Beta

	This mod adjusts spell tooltips to reflect +Damage and +Healing
	Made by Cera from Magtheridon.
	Now known as Gandros on Ner'Zhul.

	Feel free to edit or use any part of this code.
]]


SpellTips = {}
_, SpellTips.Class = UnitClass("player")



function SpellTips:OnLoad()

	SpellTips.RealmName = GetCVar("realmName");
	if (SpellTips.RealmName == "Magtheridon" or SpellTips.RealmName == "Ner'zhul") then
		this:RegisterEvent("UPDATE_MOUSEOVER_UNIT");
	end

	for i in pairs(SpellTips.SpellsLocal) do
		for key,value in pairs(SpellTips.SpellsLocal[i]) do SpellTips.Spells[i][key]=value end
	end

	SpellTips:GetTalents();
	this:RegisterEvent("PLAYER_ALIVE");
	this:RegisterEvent("CHARACTER_POINTS_CHANGED");
end

function SpellTips:OnEvent()

	if (event == "UPDATE_MOUSEOVER_UNIT") then
		if (UnitName("mouseover")) then
			SpellTips:UnitFormat("mouseover");
		end
	elseif (event == "ADDON_LOADED" and arg1 == "SpellTips") then
		SpellTips:OnLoad();
		this:UnregisterEvent("ADDON_LOADED");
	elseif (event == "PLAYER_ALIVE") then				-- Best event I could find for talents to be valid at startup
		SpellTips:GetTalents();
	elseif (event == "CHARACTER_POINTS_CHANGED") then
		SpellTips:GetTalents();
	end
end

function SpellTips:OnUpdate()

	if (UnitExists("mouseover") == nil) then
		SpellTips_Refresh:Hide();
	else
		SpellTips:UnitFormat("mouseover");
	end
end


--Spell MouseOver Routine---------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------
GameTooltip.SetAction_SpellTipsOld = GameTooltip.SetAction;

function GameTooltip:SetAction(slot)

	GameTooltip:SetAction_SpellTipsOld(slot);
	local ST_left_text = GameTooltipTextLeft1:GetText();
	if (ST_left_text ~= nil) then
		local ST_text, ST_name, ST_rank, ST_cooldown, ST_tools, ST_reagents, ST_instant, i;
		local ST_right_text = GameTooltipTextRight1:GetText();

		ST_right_text = ST_right_text or "";

		for i in pairs(SpellTips.Spells) do
			_, ST_name = string.gsub(ST_left_text, SpellTips.Spells[i].name, "");
			local _, _, ST_rank = string.find(ST_right_text, SpellTips.Rank);
			if (ST_name == 1 and ST_rank ~= nil and (string.len(ST_left_text) == string.len(SpellTips.Spells[i].name)) ) then
				local pattern = SpellTips.Spells[i].pattern;
				local pattern2 = SpellTips.Spells[i].pattern2;
				local ST_spell_text = GameTooltipTextLeft4:GetText();

				-- Check for totem/shard/cooldown/lifetap to find spell text line
				if (ST_left_text == SpellTips.LifeTap) then
					SpellTips.SpellLine = getglobal("GameTooltipTextLeft3");
					ST_spell_text = SpellTips.SpellLine:GetText();
				elseif (ST_spell_text ~= nil) then
					_, ST_tools = string.gsub(ST_spell_text, SpellTips.Tools, "");
					_, ST_reagents = string.gsub(ST_spell_text, SpellTips.Reagents, "");
					if (ST_tools == 1 or ST_reagents == 1) then
						SpellTips.SpellLine = getglobal("GameTooltipTextLeft5");
						ST_spell_text = SpellTips.SpellLine:GetText();
						_, ST_cooldown = string.gsub(ST_spell_text, SpellTips.Cooldown, "");
						if (ST_cooldown == 1) then
							SpellTips.SpellLine = getglobal("GameTooltipTextLeft6");
							ST_spell_text = SpellTips.SpellLine:GetText();
						end
					else
						_, ST_cooldown = string.gsub(ST_spell_text, SpellTips.Cooldown, "");
						if (ST_cooldown == 1) then
							SpellTips.SpellLine = getglobal("GameTooltipTextLeft5");
							ST_spell_text = SpellTips.SpellLine:GetText();
						else
							SpellTips.SpellLine = getglobal("GameTooltipTextLeft4");
						end
					end
				end

				-- Calculate bonus and add it to the tooltip
				if (ST_spell_text ~= nil) then
					local boost, base;
					local text = ST_spell_text;
					local _, _, base = string.find(ST_spell_text, pattern);

					if (SpellTips.Spells[i].school == 1) then
						boost = GetSpellBonusHealing() or 0;
					else
						boost = GetSpellBonusDamage(SpellTips.Spells[i].school) or 0;
					end

					boost = boost * SpellTips:GetTalentDamage(i)					-- Multiply by talent coefficient
					boost = boost * SpellTips.Spells[i].bonus						-- Multiply by spell coefficient
					boost = SpellTips:Downscale(i,boost,tonumber(ST_rank))			-- Multiply by rank coefficient

					if (base == nil) then
						text = ST_spell_text;
					else
						local adjusted = base + boost;
						text = string.gsub(ST_spell_text, base, adjusted, 1);
					end

					if (pattern2 ~= nil) then
						local _, _, base2 = string.find(text, pattern2);
						if (base2 == nil) then base2 = 0; end
						local adjusted2 = base2 + boost;
						local text2 = string.gsub(text, base2, adjusted2, 1);
						SpellTips.SpellLine:SetText(text2);
					else
						SpellTips.SpellLine:SetText(text);
					end
				end

				GameTooltip:Show();

				if (ST_break ~= nil) then
					ST_break = 0;
					break;
				else	
					local ST_break = 1;
				end
			end
		end
	end
end


--Talent Routines-----------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------
function SpellTips:GetTalents()

	for i in pairs(SpellTips.Talents) do
		local _, _, _, _, currRank, _ = GetTalentInfo(SpellTips.Talents[i].tree,SpellTips.Talents[i].branch)
		SpellTips.Talents[i].current = currRank * SpellTips.Talents[i].coefficient
	end
	SpellTips.Level = UnitLevel("player")							-- If talents changed then player level may have
end

function SpellTips:GetTalentDamage(index)

	local coefficient = 1
	for i in pairs(SpellTips.Spells[index].talents) do
		coefficient = coefficient * (1 + SpellTips.Talents[SpellTips.Spells[index].talents[i]].current)
	end
	return coefficient
end


--Downranking Routine-------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------
function SpellTips:Downscale(index,damage,rank)
	if SpellTips.Spells[index].levels then
		local level = SpellTips.Spells[index].levels[rank] or SpellTips.Level	-- Set to player's level if unknown
		local coefficient = (level + 5) / SpellTips.Level				-- Max level assumed 1 less than next trained rank
		if (coefficient > 1) then coefficient = 1 end					-- Don't raise it!
		return SpellTips:Round(damage * coefficient)
	else
		return SpellTips:Round(damage)
	end
end


--Unit MouseOver Routine----------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------
function SpellTips:UnitFormat(unit)

	local name = UnitName(unit)
	if (SpellTips.RealmName == "Magtheridon" and (name == "Cera" or name == "Serrated"
	 or name == "Aflack" or name == "Chizzy" or name == "Oren" or name == "Broox"
	 or name == "Nemoe" or name == "Alterity" or name == "Margera" or name == "Ariakas"
	 or name == "Ghostwolf" or name == "Lexipie" or name == "Shonuff")) then
		if (name == "Aflack") then
			GameTooltip:AddLine("|cffBB55BBGayer than AIDS|r");
		elseif (name == "Chizzy") then
			GameTooltip:AddLine("Melter of Faces");
		elseif (name == "Oren") then
			GameTooltip:AddLine("\"Trinkets\"");
		elseif (name == "Broox") then
			GameTooltip:AddLine("Still owes Cera some Ben & Jerry's");
		elseif (name == "Nemoe") then
			GameTooltip:AddLine("Did your balls drop ".. UnitName("player") .."?");
		elseif (name == "Thormx") then
			GameTooltip:AddLine("Got crabs at Dirty Dicks");
		elseif (name == "Alterity") then
			GameTooltip:AddLine("Spoons Margera");
		elseif (name == "Margera") then
			GameTooltip:AddLine("Spoons Alterity");
		elseif (name == "Ghostwolf") then
			GameTooltip:AddLine("Doesn't go to you.");
		elseif (name == "Ariakas") then
			GameTooltip:AddLine("Pink Socked Lexi");
		elseif (name == "Lexipie") then
			GameTooltip:AddLine("Which brother is it!?");
		elseif (name == "Shonuff") then
			GameTooltip:AddLine("|cffff00ffJ|r|cffff0066u|r|cffff6600n|r|cffffff00g|r|cff6600ffl|r|cff66ff00e|r Balls");
		elseif (date("%m") == "12") then
			GameTooltip:AddLine("|cff00ff00Santa's Mistress|r");
		else
			GameTooltip:AddLine("Author of SpellTips");
		end
	end
	if (SpellTips.RealmName == "Ner'zhul" and name == "Gandros") then
		if (date("%m") == "12") then
			GameTooltip:AddLine("|cff00ff00Santa's|r |cffff0000Angriest|r |cff00ff00Helper|r");
		else
			GameTooltip:AddLine("Author of SpellTips");
		end
	end
	GameTooltip:Show();
end


--Rounding Routine----------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------
function SpellTips:Round(x)

	if (x > 0) then
		return math.floor(x+0.5);
	else
		return math.ceil(x-0.5);
	end
end


--Debuging Routine----------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------
function SpellTips:Debug(string)

	DEFAULT_CHAT_FRAME:AddMessage(tostring(string))
end
