TITAN_ITEMDED_ID = "ItemDed";

ITEMDED_WARN_THRESHOLD = 4;

-- Local variables
local TPID_isLoaded = false;
local TitanItemDed_ignored = {};
local TitanItemDed_ItemList = {}; 
-- Better use at least one character that guaranteed not to appear in player name or realm name
local PlayerIdent = GetCVar("RealmName").."|"..UnitName("player");
-- Use placeholders instead of real RGB values. Next for will fill them with actual game data.
local TPID_Color = {
	{nil, TITAN_ITEMDED_QUALITY_JUNK},		-- gray
	{nil, TITAN_ITEMDED_QUALITY_COMMON},		-- white
	{nil, TITAN_ITEMDED_QUALITY_UNCOMMON},		-- green
	{nil, TITAN_ITEMDED_QUALITY_RARE},		-- blue
	{nil, TITAN_ITEMDED_QUALITY_EPIC},		-- purple
};

for idx = 1, 5 do
	local _, _, _, hex = GetItemQualityColor(idx-1)
	TPID_Color[idx][1]=hex
end

function TitanItemDed_OnLoad()
	this.registry = { 
		id = TITAN_ITEMDED_ID,
		menuText = TITAN_ITEMDED_MENU_TEXT, 
		buttonTextFunction = "TitanPanelItemDedButton_GetButtonText", 
		tooltipTitle = TITAN_ITEMDED_TOOLTIP_TITLE,
		tooltipTextFunction = "TitanPanelItemDedButton_GetTooltipText", 
		icon = "",	
		iconWidth = 16,
		category = "Information",
		savedVariables = {
			ShowIcon = 1,
--			ShowIcon2 = 1,
			ShowLabelText = 1,
			ShowChatFeedback = 1
--			ShowTTHelp = 1,
--			IgnoreFaire = 1,
--			RoundStacks = 1,
--			RoundOnlyIfFullStack = 1,
		}
	};
	
	this:RegisterEvent("VARIABLES_LOADED");
	this:RegisterEvent("BAG_UPDATE");
	this:RegisterEvent("MERCHANT_SHOW");

--   	if (TitanItemDed_OverridePrices) then
--		for itemid,val in pairs(TitanItemDed_OverridePrices) do
--			if (not TitanItemDed_itemsbyid[itemid]) then TitanItemDed_itemsbyid[itemid] = {} end
--			TitanItemDed_itemsbyid[itemid].s = val;
--			TitanItemDed_itemsbyid[itemid].isusr = true;
--		end
--	end
end

function TitanPanelItemDedButton_UpdateIcon()
	TitanItemDed_MakeList();

	local button = TitanUtils_GetButton(TITAN_ITEMDED_ID, true);
	
	if (TitanItemDed_ItemList[1]) then
		button.registry.icon = TitanItemDed_ItemList[1].tex;
	else
		button.registry.icon = "";
	end
	
	TitanPanelButton_UpdateButton(TITAN_ITEMDED_ID);
end

function TitanPanelItemDedButton_GetButtonText(id)
	local numempty = TitanItemDed_GetEmpties();
	local itemtext;
	local numtxt = "(".. numempty.. ")";

	if (TitanItemDed_ItemList[1]) then
		itemtext = TitanItemDed_ItemList[1].fullname.. " ";
	else
		itemtext = "No Item ";
	end
		
	if (numempty < ITEMDED_WARN_THRESHOLD) then
		numtxt = TitanUtils_GetRedText(numtxt);
	else
		numtxt = TitanUtils_GetNormalText(numtxt);
	end
	
	return itemtext, numtxt;
end

function TitanPanelItemDedButton_GetTooltipText()
	local retstr = TITAN_ITEMDED_TOOLTIP_BAGS;

	if (TitanItemDed_ItemList[1]) then
		if (MerchantFrame:IsVisible()) then
			retstr = retstr.. TITAN_ITEMDED_TOOLTIP_SELL;
			retstr = retstr.. TITAN_ITEMDED_TOOLTIP_IGNORE;		
		else
			retstr = retstr.. TITAN_ITEMDED_TOOLTIP_DESTROY;
			retstr = retstr.. TITAN_ITEMDED_TOOLTIP_IGNORE;
		end

		for i,entry in ipairs(TitanItemDed_ItemList) do
			retstr = retstr.. entry.fullname.. "\t".. TitanItemDed_GetTextGSC(entry.price)..  "\n";
		end
	else
		retstr = retstr.. TITAN_ITEMDED_CHAT_FEEDBACK_NO_ITEM_TO_DESTROY;
	end
	
	return retstr;	
end

function TitanItemDed_OnEvent()
	if (event == "VARIABLES_LOADED") then
		TitanItemDed_Init();
		TPID_isLoaded = true;
		TitanPanelItemDedButton_UpdateIcon();
	end
	if (event == "BAG_UPDATE") then
		TitanPanelItemDedButton_UpdateIcon();
	end
end

function TitanPanelRightClickMenu_PrepareItemDedMenu()
	if (not TPID_isLoaded) then return; end
	
	local info;
	
	TitanPanelRightClickMenu_AddTitle(TitanPlugins[TITAN_ITEMDED_ID].menuText);
	TitanPanelRightClickMenu_AddSpacer();		
	
	if (MerchantFrame:IsVisible() and (not IsAddOnLoaded("Sell-O-Matic"))) then 
		info = {};
		info.text = TITAN_ITEMDED_MENU_SELL_ALL_JUNK;
		info.func = TitanItemDed_SellJunk;
		UIDropDownMenu_AddButton(info);
	end

	info = {};
	if (MerchantFrame:IsVisible()) then info.text = TITAN_ITEMDED_MENU_SELL_ITEM;
	else info.text = TITAN_ITEMDED_MENU_DROP_ITEM; end
	info.func = TitanItemDed_Listman;
	info.value = "t";
	UIDropDownMenu_AddButton(info);

	TitanPanelRightClickMenu_AddSpacer();		

	info = {};
	info.text = TITAN_ITEMDED_MENU_IGNORE_ITEM;
	info.value = "i";
	info.func = TitanItemDed_Listman;
	UIDropDownMenu_AddButton(info);

	info = {};
	info.text = TITAN_ITEMDED_MENU_ALWAYS_IGNORE_ITEM;
	info.value = "ia";
	info.func = TitanItemDed_Listman;
	UIDropDownMenu_AddButton(info);
	
	TitanPanelRightClickMenu_AddSpacer();		

	info = {};
	info.text = TITAN_ITEMDED_MENU_RESET_IGNORE_LIST;
	info.value = "r";
	info.func = TitanItemDed_Listman;
	UIDropDownMenu_AddButton(info);

	info = {};
	info.text = TITAN_ITEMDED_MENU_RESET_ALWAYS_IGNORE_LIST;
	info.value = "ra";
	info.func = TitanItemDed_Listman;
	UIDropDownMenu_AddButton(info);
	
	TitanPanelRightClickMenu_AddSpacer();	
	
	TitanPanelRightClickMenu_AddTitle(TITAN_ITEMDED_MENU_THRESHOLD);
	for i=1,5 do
		info = {};
		info.text = TPID_Color[i][1]..TPID_Color[i][2];
		info.value = i;
		info.func = TitanItemDed_SetThreshold;
		info.checked = (i == TitanItemDedSettings[PlayerIdent].Threshold);
		UIDropDownMenu_AddButton(info);
	end
	
	TitanPanelRightClickMenu_AddSpacer();		
	TitanPanelRightClickMenu_AddToggleIcon(TITAN_ITEMDED_ID);
	TitanPanelRightClickMenu_AddToggleLabelText(TITAN_ITEMDED_ID);

	info = {};
	info.text = TITAN_ITEMDED_MENU_CHAT_FEEDBACK;
	info.value = "ShowChatFeedback";
	info.func = TitanItemDed_ToggleChatback;
	info.checked = TitanGetVar(TITAN_ITEMDED_ID, "ShowChatFeedback");
	UIDropDownMenu_AddButton(info);

	TitanPanelRightClickMenu_AddSpacer();		
	TitanPanelRightClickMenu_AddCommand(TITAN_PANEL_MENU_HIDE, TITAN_ITEMDED_ID, TITAN_PANEL_MENU_FUNC_HIDE);
end


function TitanItemDed_ToggleChatback()
	TitanToggleVar(TITAN_ITEMDED_ID, "ShowChatFeedback");
end

function TitanItemDed_OnClick(button)
	if (button == "LeftButton") then
		if(IsShiftKeyDown()) then
			TitanItemDed_Listman("t");
		else
			OpenAllBags();
		end
	end
end

function TitanItemDed_OnDoubleClick(button)
	if (button == "LeftButton") then
		if(IsAltKeyDown()) then
			TitanItemDed_Listman("ia");
		else
			TitanItemDed_Listman("i");
		end
	end
end

function TitanItemDed_SetThreshold()
	TitanItemDedSettings[PlayerIdent].Threshold = this.value;
	local str = TPID_Color[this.value][1]..TPID_Color[this.value][2];
	TitanItemDed_Chatback("Threshold set to ".. str);
	TitanPanelItemDedButton_UpdateIcon();
end

function TitanItemDed_Chatback(str)
	if (TitanGetVar(TITAN_ITEMDED_ID, "ShowChatFeedback")) then
		DEFAULT_CHAT_FRAME:AddMessage("<ItemDed> ".. str);
	end
end

function TitanItemDed_GetFullName(name, qual)
	return TPID_Color[qual][1].."[".. name.. "]".. FONT_COLOR_CODE_CLOSE;
end

function TitanItemDed_GetPrice(itemId, ...)
	local price
	-- First ask Informant - its list is more complete and language independent
	if(Informant and Informant.GetItem) then
		local itemData = Informant.GetItem(itemId)
		if(itemData) then price = itemData.itemSell or itemData.sell end
		return price
	end
	local itemName=GetItemInfo(itemId)
	if (not price and itemName and TitanItemDed_items[itemName]) then
		price = TitanItemDed_items[itemName];
	end
end


function TitanItemDed_MakeList()
	TitanItemDed_ItemList = {};
	
	for bag=0,NUM_BAG_FRAMES do
		for slot=1,GetContainerNumSlots(bag) do
			local price = nil;
			local item_name = TitanItemDed_GetItemName(bag, slot);
			local item_id = TitanItemDed_GetItemId(bag, slot);
			local item_texture, stackCount = GetContainerItemInfo(bag, slot);

			if (item_name and stackCount) then
				price = TitanItemDed_GetPrice(item_id)

				if (price) then price = price * stackCount; end

				if (price) then
					if TitanItemDed_IsDroppable(bag, slot) then
						local qual = TitanItemDed_GetQuality(bag, slot);
						local n = {};
						n.price = price;
						n.name = item_name;
						n.id = item_id
						n.fullname = TitanItemDed_GetFullName(item_name, qual).. " x".. stackCount;
						n.stack = stackCount;
						n.bag = bag;
						n.slot = slot;
						n.tex = item_texture;
						table.insert(TitanItemDed_ItemList, n);
					end
				end
			end

			if (ID_Debug and item_name and item_isGray and price) then debug_message(item_name, price.." Gray");	end		
			if (ID_Debug and item_name and item_isGray == false and price) then debug_message(item_name, price); end
		end
	end
	
	table.sort(TitanItemDed_ItemList, function(a,b) return a.price<b.price end);
end

function TitanItemDed_Init()
	if (TitanItemDed_alwaysIgnored == nil) then TitanItemDed_alwaysIgnored = {}; end
	if (TitanItemDed_newItems == nil) then TitanItemDed_newItems = {}; end
	TitanItemDed_CleanSaved();
	
	if (TitanItemDedSettings == nil) then
		TitanItemDedSettings = {};
	end

	if (TitanItemDedSettings[PlayerIdent] == nil) then
		TitanItemDedSettings[PlayerIdent] = {};
		TitanItemDedSettings[PlayerIdent].Ignored = {};
		TitanItemDedSettings[PlayerIdent].Threshold = 1;
	end

	if (TitanItemDedSettings[PlayerIdent].Ignored == nil) then
		TitanItemDedSettings[PlayerIdent].Ignored = {};
	end

	if (TitanItemDedSettings[PlayerIdent].Threshold == nil) then
		TitanItemDedSettings[PlayerIdent].Threshold = 1;
	end

	if (not TitanItemDed_unknowns) then
		TitanItemDed_unknowns = {};
	end
			
	TitanPanelItemDedButton_UpdateIcon();
	
	return;
end

function TitanItemDed_Listman(cmd, itemidx)
	local act = cmd;
	local item = TitanItemDed_ItemList[itemidx];
	if (not act) then act = this.value; end
	if (not item) then item = TitanItemDed_ItemList[1]; end
	
	if (act == "i") then
		if item then TitanItemDed_ignored[item.id] = 1; end
		if item then TitanItemDed_Chatback(string.format(TITAN_ITEMDED_CHAT_FEEDBACK_ITEM_IGNORED, item.name)); 
		else TitanItemDed_Chatback(TITAN_ITEMDED_CHAT_FEEDBACK_NOTHING_TO_IGNORE); end
	end
	if (act == "ia") then
		if item then TitanItemDedSettings[PlayerIdent]["Ignored"][item.id] = 1; end
		if item then TitanItemDed_Chatback(string.format(TITAN_ITEMDED_CHAT_FEEDBACK_ITEM_ALWAYS_IGNORED, item.name));
		else TitanItemDed_Chatback(TITAN_ITEMDED_CHAT_FEEDBACK_NOTHING_TO_IGNORE); end
	end
	if (act == "r") then
		TitanItemDed_ignored = {};
		TitanItemDed_Chatback(TITAN_ITEMDED_CHAT_FEEDBACK_RESET_IGNORE_LIST);
	end
	if (act == "ra") then
		TitanItemDed_ignored = {};
		TitanItemDedSettings[PlayerIdent]["Ignored"] = {};
		TitanItemDed_Chatback(TITAN_ITEMDED_CHAT_FEEDBACK_RESET_ALWAYS_IGNORE_LIST);
	end
	if (act == "t") then
		if item then 
			if (MerchantFrame:IsVisible()) then
				UseContainerItem(item.bag, item.slot);
			else
				TitanItemDed_Chatback(string.format(TITAN_ITEMDED_CHAT_FEEDBACK_ITEM_DELETED, item.fullname, item.price));
				PickupContainerItem(item.bag, item.slot);
				DeleteCursorItem();
			end
		else
			TitanItemDed_Chatback(TITAN_ITEMDED_CHAT_FEEDBACK_NO_ITEM_TO_DESTROY);
		end
	end
	
	TitanPanelItemDedButton_UpdateIcon();
end

function TitanItemDed_SellJunk()
	for bag=0,NUM_BAG_FRAMES do
		for slot=1,GetContainerNumSlots(bag) do
			local qual = TitanItemDed_GetQuality(bag, slot);
			
			if (qual) then
				if ((qual == 1) and (MerchantFrame:IsVisible())) then
					UseContainerItem(bag, slot);
				end
			end
		end
	end
end

-------------------------------------------------------------------------------
-- Bag Search functions
-------------------------------------------------------------------------------

function TitanItemDed_GetItemLink(bag, slot)
	if (bag == -1) then
		return GetInventoryItemLink("player", slot);
	else
		return GetContainerItemLink(bag, slot);
	end
end	

function TitanItemDed_GetItemName(bag, slot)
	local link = TitanItemDed_GetItemLink(bag, slot)
	if(link) then
		local itemName = GetItemInfo(link)
		return itemName
	end
		return nil
end

function TitanItemDed_GetItemId(bag, slot)
	local link = TitanItemDed_GetItemLink(bag, slot)
	if(link) then
		local _, _, itemId = string.find(link, "item:(%d+):")
		return tonumber(itemId)
	end
	return nil
end
   
function TitanItemDed_GetQuality(bag, slot)
	local link = TitanItemDed_GetItemLink(bag, slot)
	if (link) then
		local _, _, itemRarity = GetItemInfo(link)
		return itemRarity+1	-- TitanItemDed indexes go from 1 (Lua convention) instead of Blizzard's 0 (C convention)
	end
	return nil;
end

function TitanItemDed_IsDroppable(bag, slot)
	local itemId = TitanItemDed_GetItemId(bag, slot);
	if TitanItemDed_ignored[itemId] then return false; end;
	if TitanItemDedSettings[PlayerIdent]["Ignored"][itemId] then return false; end;
	if (TitanItemDed_GetQuality(bag, slot) > TitanItemDedSettings[PlayerIdent].Threshold) then return false; end;
	return true;
end

function TitanItemDed_GetEmpties()
	local numempty = 0;
	for bag=0,NUM_BAG_FRAMES do
		if (TitanItemDed_IsAmmoBag(bag)) then
			-- Do Nothing
		else
			for slot=1,GetContainerNumSlots(bag) do
				local itemLink = TitanItemDed_GetItemLink(bag, slot);
			  	if (not itemLink) then numempty = numempty+1; end
			end
		end
	end
	return numempty;
end

function TitanItemDed_IsAmmoBag(bag)
	if(bag<1 or bag>11) then return nil end
	local bagInvId=ContainerIDToInventoryID(bag)
	if(not bagInvId) then return nil end
	local bagLink=GetInventoryItemLink("player", bagInvId)
	if(not bagLink) then return nil end
        _, _, _, _, _, bagType = GetItemInfo(bagLink)
	if(not bagType) then return nil end
	if(bagType == "Quiver") then
		return true
	else
		return false;
	end
end

-------------------------------------------------------------------------------
-- Gold formatting code, shamelessly "borrowed" from Auctioneer
-------------------------------------------------------------------------------

function TitanItemDed_GetGSC(money)
	if (money == nil) then money = 0; end
	local g = math.floor(money / 10000);
	local s = math.floor((money - (g*10000)) / 100);
	local c = math.floor(money - (g*10000) - (s*100));
	return g,s,c;
end

GSC_GOLD="ffd100";
GSC_SILVER="e6e6e6";
GSC_COPPER="c8602c";
GSC_START="|cff%s%d|r";
GSC_PART=".|cff%s%02d|r";
GSC_NONE="|cffa0a0a0none|r";

function TitanItemDed_GetTextGSC(money)
	local g, s, c = TitanItemDed_GetGSC(money);
	local gsc = "";
	if (g > 0) then
		gsc = format(GSC_START, GSC_GOLD, g);
		if ((s > 0) or (c > 0)) then
			if (c > 50) then s = s+1; end
			gsc = gsc..format(GSC_PART, GSC_SILVER, s);
		end
	elseif (s > 0) then
		gsc = format(GSC_START, GSC_SILVER, s);
		if (c > 0) then
			gsc = gsc..format(GSC_PART, GSC_COPPER, c);
		end
	elseif (c > 0) then
		gsc = gsc..format(GSC_START, GSC_COPPER, c);
	else
		gsc = GSC_NONE;
	end

	return gsc;
end

-------------------------------------------------------------------------------
-- External Mod search functions
-------------------------------------------------------------------------------

function TitanItemDed_GetEconPrice(item_name)
	if (WOWEcon_Prices[item_name]) then return WOWEcon_Prices[item_name][1]; end
	return nil;
end

function TitanItemDed_CmdScan()
	-- Scan WoWEcon's list, if it exists
	if (WOWEcon_Prices) then
		for item in WOWEcon_Prices do
			if ( (WOWEcon_Prices[item][1]) and (TitanItemDed_newItems[item] == nil) and (TitanItemDed_items[item] == nil) ) then
				if (WOWEcon_Prices[item][1] > 0) then
					TitanItemDed_newItems[item] = WOWEcon_Prices[item][1];
				end
			end
		end
	end
end

function TitanItemDed_CleanSaved()
	local oldNews = TitanItemDed_newItems;
	TitanItemDed_newItems = {};
	
	for item in pairs(oldNews) do
		if (not TitanItemDed_items[item]) then
			TitanItemDed_newItems[item] = oldNews[item];
		end
	end
end