------------------------------------------------
--                CT_PartyBuffs               --
--                                            --
-- Simple addon to display buffs and debuffs  --
-- of party members at their party portraits. --
-- Please do not modify or otherwise          --
-- redistribute this without the consent of   --
-- the CTMod Team. Thank you.                 --
------------------------------------------------

--------------------------------------------
-- Initialization

local module = { };
local _G = getfenv(0);

local MODULE_NAME = "CT_PartyBuffs";
local MODULE_VERSION = strmatch(GetAddOnMetadata(MODULE_NAME, "version"), "^([%d.]+)");

module.name = MODULE_NAME;
module.version = MODULE_VERSION;

_G[MODULE_NAME] = module;
CT_Library:registerModule(module);

--------------------------------------------
-- General Mod Code (recode imminent!)
CT_NUM_PARTY_BUFFS = 14;
CT_NUM_PARTY_DEBUFFS = 6;
CT_NUM_PET_BUFFS = 9;
local numBuffs, numDebuffs, numPetBuffs;

function CT_PartyBuffs_OnLoad()
	PetFrameDebuff1:SetPoint("TOPLEFT", "PetFrame", "TOPLEFT", 48, -59);
end


function CT_PartyBuffs_RefreshBuffs(elapsed)
	this.update = this.update + elapsed;
	if ( this.update > 0.5 ) then
		this.update = 0.5 - this.update;
		local name = this:GetName();
			local i;
			
		if ( numBuffs == 0 ) then
			for i = 1, CT_NUM_PARTY_BUFFS, 1 do
				getglobal(name .. "Buff" .. i):Hide();
			end
			return;
		end
		for i = 1, CT_NUM_PARTY_BUFFS, 1 do
			if ( i > numBuffs ) then
				getglobal(name .. "Buff" .. i):Hide();
			else
				local _, _, bufftexture = UnitBuff("party" .. this:GetID(), i);
				if ( bufftexture ) then
					getglobal(name .. "Buff" .. i .. "Icon"):SetTexture(bufftexture);
					getglobal(name .. "Buff" .. i):Show();
				else
					getglobal(name .. "Buff" .. i):Hide();
				end
				
				if ( i <= 4 ) then
					getglobal("PartyMemberFrame" .. this:GetID() .. "Debuff" .. i):Hide();
				end
				if ( i <= CT_NUM_PARTY_DEBUFFS ) then
					if ( i > numDebuffs ) then
						getglobal(name .. "Debuff" .. i):Hide();
					else
						local _, _, debufftexture, debuffApplications, debuffType = UnitDebuff("party" .. this:GetID(), i);
						if ( debufftexture ) then
							local color;
							if ( debuffApplications > 1 ) then
								getglobal(name .. "Debuff" .. i .. "Count"):SetText(debuffApplications);
							else
								getglobal(name .. "Debuff" .. i .. "Count"):SetText("");
							end
							if ( debuffType ) then
								color = DebuffTypeColor[debuffType];
							else
								color = DebuffTypeColor["none"];
							end
							getglobal(name .. "Debuff" .. i .. "Icon"):SetTexture(debufftexture);
							getglobal(name .. "Debuff" .. i):Show();
							getglobal(name .. "Debuff" .. i .. "Border"):SetVertexColor(color.r, color.g, color.b);
						else
							getglobal(name .. "Debuff" .. i):Hide();
						end
					end
				end
			end
		end
	end
end

function CT_PartyBuffs_RefreshPetBuffs(elapsed)
	this.update = this.update + elapsed;
	if ( this.update > 0.5 ) then
		this.update = 0.5 - this.update
		local i;
		if ( numPetBuffs == 0 ) then
			module:print("Hiding all pet buffs");
			for i = 1, CT_NUM_PET_BUFFS, 1 do
				getglobal(this:GetName() .. "Buff" .. i):Hide();
			end
			return;
		end
		local _, _, bufftexture;
		for i = 1, CT_NUM_PET_BUFFS, 1 do
			if ( i > numPetBuffs ) then
				getglobal(this:GetName() .. "Buff" .. i):Hide();
			else
				_, _, bufftexture = UnitBuff("pet", i);
				if ( bufftexture ) then
					getglobal(this:GetName() .. "Buff" .. i .. "Icon"):SetTexture(bufftexture);
					getglobal(this:GetName() .. "Buff" .. i):Show();
				else
					getglobal(this:GetName() .. "Buff" .. i):Hide();
				end
			end
		end
	end
end

CT_oldPartyMemberBuffTooltip_Update = PartyMemberBuffTooltip_Update;
function CT_newPartyMemberBuffTooltip_Update(pet)
	CT_oldPartyMemberBuffTooltip_Update(pet);
	if ( ( pet and numPetBuffs > 0 ) or ( not pet and numBuffs > 0 ) ) then
		PartyMemberBuffTooltip:Hide();
	end
end
PartyMemberBuffTooltip_Update = CT_newPartyMemberBuffTooltip_Update;

--------------------------------------------
-- Options Frame Code
module.frame = function()
	return "frame#all", {
		"slider#t:0:-15#s:190:17#o:numBuffs:4#Buffs Displayed - <value>#0:14:1",
		"slider#t:0:-50#s:190:17#o:numDebuffs:6#Debuffs Displayed - <value>#0:6:1",
		"slider#t:0:-85#s:190:17#o:numPetBuffs:4#Pet Buffs Displayed - <value>#0:14:1"
	}
end

module.update = function(self, type, value)
	if ( type == "init" ) then
		numBuffs = self:getOption("numBuffs") or 4;
		numDebuffs = self:getOption("numDebuffs") or 6;
		numPetBuffs = self:getOption("numPetBuffs") or 4;
	elseif ( type == "numBuffs" ) then
		numBuffs = value;
	elseif ( type == "numDebuffs" ) then
		numDebuffs = value;
	elseif ( type == "numPetBuffs" ) then
		numPetBuffs = value;
	end
end