HealBot_ConfigDefaults = {
  Version = HEALBOT_VERSION,
  AlertLevel = 0.75,
  AutoClose = 0,
  PanelSounds = 1,
  SelfHeals = 0,
  GroupHeals = 1,
  TankHeals = 1,
  TargetHeals = 0,
  EmergencyHeals = 1,
  PetHeals = 0,
  ActionLocked = 0,
  OverHeal = 0.25,
  CastNotify = 1,
  HideOptions = 0,
  HideAbort = 1,
  ShowTooltip = 1,
  GrowUpwards = 0,
  ProtectPvP = 0,
  EmergIncMonitor = 1,
  EmergencyFClass = 4,
  ExtraOrder      = 1,
  ShowDebuffWarning = 1,
  SoundDebuffWarning = 0,
  SoundDebuffPlay = 1,
  CDCMonitor = 1,
  PanelAnchorX = -1,
  PanelAnchorY = -1,
  ShowClassOnBar = 0,
  ShowHealthOnBar = 1,
  BarHealthType = 1,
  BarHealthIncHeals = 1,
  ShowClassOnBarWithName = 0,
  SetClassColourText = 1,
  RightButtonOptions = 1,
  BuffWatch = 1,
  BuffWatchInCombat = 0,
  DebuffWatch = 1,
  DebuffWatchInCombat = 1,
  IgnoreClassDebuffs = 1,
  IgnoreMovementDebuffs = 0,
  IgnoreFastDurDebuffs = 1,
  IgnoreNonHarmfulDebuffs = 1,
  SmartCast = 1,
  SmartCastDebuff = 1,
  SmartCastBuff = 1,
  SmartCastHeal = 1,
  SmartCastRes = 1,
  RangeCheckFreq=0.8,
  RangeCheckUnits=7,
  HidePartyFrames=0,
  HidePlayerTarget=0,
  DisableHealBot=0,
  HealBot_ButtonRadius=78,
  HealBot_ButtonPosition=300,
  ButtonShown=1,
  NotifyChan="",
  ShowHoTicons=1,
  CDCBarColour = {
    [HEALBOT_DISEASE_en] = { R = 0.1, G = 0.05, B = 0.2, },
    [HEALBOT_MAGIC_en] = { R = 0.05, G = 0.05, B = 0.1, },
    [HEALBOT_POISON_en] = { R = 0.05, G = 0.2, B = 0.1, },
    [HEALBOT_CURSE_en] = { R = 0.2, G = 0.05, B = 0.05, },
  },
  EmergIncRange = {
    [HEALBOT_DRUID]    = 0,
    [HEALBOT_HUNTER]   = 1,
    [HEALBOT_MAGE]     = 1,
    [HEALBOT_PALADIN]  = 0,
    [HEALBOT_PRIEST]   = 0,
    [HEALBOT_ROGUE]    = 0,
    [HEALBOT_SHAMAN]   = 0,
    [HEALBOT_WARLOCK]  = 1,
    [HEALBOT_WARRIOR]  = 0,
  },
  EmergIncMelee = {
    [HEALBOT_DRUID]    = 0,
    [HEALBOT_HUNTER]   = 0,
    [HEALBOT_MAGE]     = 0,
    [HEALBOT_PALADIN]  = 0,
    [HEALBOT_PRIEST]   = 0,
    [HEALBOT_ROGUE]    = 1,
    [HEALBOT_SHAMAN]   = 0,
    [HEALBOT_WARLOCK]  = 0,
    [HEALBOT_WARRIOR]  = 1,
  },
  EmergIncHealers = {
    [HEALBOT_DRUID]    = 1,
    [HEALBOT_HUNTER]   = 0,
    [HEALBOT_MAGE]     = 0,
    [HEALBOT_PALADIN]  = 0,
    [HEALBOT_PRIEST]   = 1,
    [HEALBOT_ROGUE]    = 0,
    [HEALBOT_SHAMAN]   = 0,
    [HEALBOT_WARLOCK]  = 0,
    [HEALBOT_WARRIOR]  = 0,
  },
  EmergIncCustom = {
    [HEALBOT_DRUID]    = 1,
    [HEALBOT_HUNTER]   = 0,
    [HEALBOT_MAGE]     = 1,
    [HEALBOT_PALADIN]  = 1,
    [HEALBOT_PRIEST]   = 1,
    [HEALBOT_ROGUE]    = 0,
    [HEALBOT_SHAMAN]   = 1,
    [HEALBOT_WARLOCK]  = 1,
    [HEALBOT_WARRIOR]  = 0,
  },
  KeyCombo = {
    [HEALBOT_DRUID] = {
      ["Left"] = HEALBOT_REGROWTH,
      ["ShiftLeft"] = HEALBOT_REGROWTH .. HEALBOT_RANK_7,
      ["CtrlLeft"] = HEALBOT_DISABLED_TARGET,
      ["AltLeft"] =  HEALBOT_ABOLISH_POISON,
      ["Right"] = HEALBOT_HEALING_TOUCH,
      ["ShiftRight"] = HEALBOT_HEALING_TOUCH .. HEALBOT_RANK_8,
      ["CtrlRight"] = HEALBOT_ASSIST,
      ["AltRight"] =  HEALBOT_REMOVE_CURSE,
      ["Middle"] = HEALBOT_REJUVENATION,
      ["ShiftMiddle"] = HEALBOT_REJUVENATION .. HEALBOT_RANK_8,
      ["CtrlMiddle"] = HEALBOT_REJUVENATION .. HEALBOT_RANK_6,
      ["AltMiddle"] = HEALBOT_HEAVY_RUNECLOTH_BANDAGE,
      ["Button4"] = HEALBOT_MARK_OF_THE_WILD,
      ["ShiftButton4"] = HEALBOT_MAJOR_HEALING_POTION,
      ["Button5"] = HEALBOT_FOCUS,
    },
    [HEALBOT_PALADIN] = {
      ["Left"] = HEALBOT_FLASH_OF_LIGHT,
      ["ShiftLeft"] = HEALBOT_FLASH_OF_LIGHT .. HEALBOT_RANK_5,
      ["CtrlLeft"] = HEALBOT_DISABLED_TARGET,
      ["AltLeft"] =  HEALBOT_CLEANSE,
      ["Right"] = HEALBOT_HOLY_LIGHT,
      ["ShiftRight"] = HEALBOT_HOLY_LIGHT .. HEALBOT_RANK_8,
      ["CtrlRight"] = HEALBOT_ASSIST,
      ["Middle"] =  HEALBOT_BLESSING_OF_SALVATION,
      ["ShiftMiddle"] = HEALBOT_HEAVY_RUNECLOTH_BANDAGE,
      ["CtrlMiddle"] = HEALBOT_FOCUS,
      ["AltMiddle"] = HEALBOT_MAJOR_HEALING_POTION,
      },
    [HEALBOT_PRIEST] = {
      ["Left"] = HEALBOT_FLASH_HEAL,
      ["ShiftLeft"] = HEALBOT_FLASH_HEAL .. HEALBOT_RANK_5,
      ["CtrlLeft"] = HEALBOT_DISABLED_TARGET,
      ["AltLeft"] =  HEALBOT_ABOLISH_DISEASE,
      ["Right"] = HEALBOT_GREATER_HEAL,
      ["ShiftRight"] = HEALBOT_GREATER_HEAL .. HEALBOT_RANK_2,
      ["CtrlRight"] = HEALBOT_ASSIST,
      ["AltRight"] =  HEALBOT_DISPEL_MAGIC,
      ["Middle"] = HEALBOT_RENEW,
      ["ShiftMiddle"] = HEALBOT_RENEW .. HEALBOT_RANK_7,
      ["CtrlMiddle"] = HEALBOT_POWER_WORD_SHIELD,
      ["AltMiddle"] = HEALBOT_PRAYER_OF_HEALING,
      ["Button4"] = HEALBOT_POWER_WORD_FORTITUDE,
      ["ShiftButton4"] = HEALBOT_POWER_WORD_FORTITUDE,
      ["Button5"] = HEALBOT_MAJOR_HEALING_POTION,
      ["ShiftButton5"] = HEALBOT_HEAVY_RUNECLOTH_BANDAGE,
      ["AltButton5"] = HEALBOT_FOCUS,
    },
    [HEALBOT_SHAMAN] = {
      ["Left"] = HEALBOT_LESSER_HEALING_WAVE,
      ["ShiftLeft"] = HEALBOT_LESSER_HEALING_WAVE .. HEALBOT_RANK_5,
      ["CtrlLeft"] = HEALBOT_DISABLED_TARGET,
      ["AltLeft"] =  HEALBOT_CURE_POISON,
      ["Right"] = HEALBOT_HEALING_WAVE,
      ["ShiftRight"] = HEALBOT_HEALING_WAVE .. HEALBOT_RANK_8,
      ["CtrlRight"] = HEALBOT_ASSIST,
      ["AltRight"] =  HEALBOT_CURE_DISEASE,
      ["Middle"] = HEALBOT_CHAIN_HEAL,
      ["ShiftMiddle"] = HEALBOT_HEAVY_RUNECLOTH_BANDAGE,
      ["CtrlMiddle"] = HEALBOT_MAJOR_HEALING_POTION,
      ["Button4"] = HEALBOT_FOCUS,
      },
    [HEALBOT_HUNTER]   = {
      ["Left"] = HEALBOT_DISABLED_TARGET,
      ["ShiftLeft"] = HEALBOT_HEAVY_RUNECLOTH_BANDAGE,
      ["Right"] = HEALBOT_ASSIST,
      ["ShiftRight"] = HEALBOT_MAJOR_HEALING_POTION,
      },
    [HEALBOT_MAGE]     = {
      ["Left"] = HEALBOT_REMOVE_LESSER_CURSE,
      ["CtrlLeft"] = HEALBOT_DISABLED_TARGET,
      ["ShiftLeft"] = HEALBOT_HEAVY_RUNECLOTH_BANDAGE,
      ["Right"] = HEALBOT_ASSIST,
      ["ShiftRight"] = HEALBOT_MAJOR_HEALING_POTION,
      },
    [HEALBOT_ROGUE]    = {
      ["Left"] = HEALBOT_DISABLED_TARGET,
      ["ShiftLeft"] = HEALBOT_HEAVY_RUNECLOTH_BANDAGE,
      ["Right"] = HEALBOT_ASSIST,
      ["ShiftRight"] = HEALBOT_MAJOR_HEALING_POTION,
      },
    [HEALBOT_WARLOCK]  = {
      ["Left"] = HEALBOT_DISABLED_TARGET,
      ["ShiftLeft"] = HEALBOT_HEAVY_RUNECLOTH_BANDAGE,
      ["Right"] = HEALBOT_ASSIST,
      ["ShiftRight"] = HEALBOT_MAJOR_HEALING_POTION,
      },
    [HEALBOT_WARRIOR]  = {
      ["Left"] = HEALBOT_DISABLED_TARGET,
      ["ShiftLeft"] = HEALBOT_HEAVY_RUNECLOTH_BANDAGE,
      ["Right"] = HEALBOT_ASSIST,
      ["ShiftRight"] = HEALBOT_MAJOR_HEALING_POTION,
      },
  },
  DisKeyCombo = {
    [HEALBOT_DRUID] = {
      ["Left"] = HEALBOT_DISABLED_TARGET,
      ["ShiftLeft"] = HEALBOT_FOCUS,
      ["CtrlLeft"] = HEALBOT_ASSIST,
      ["AltLeft"] = HEALBOT_THORNS,
      ["Right"] = HEALBOT_MARK_OF_THE_WILD,
      ["Middle"] = HEALBOT_REJUVENATION,
      ["AltMiddle"] = HEALBOT_REBIRTH,
    },
    [HEALBOT_PALADIN] = {
      ["Left"] = HEALBOT_DISABLED_TARGET,
      ["ShiftLeft"] = HEALBOT_FOCUS,
      ["CtrlLeft"] = HEALBOT_ASSIST,
      ["Right"] = HEALBOT_REDEMPTION,
      ["Middle"] =  HEALBOT_BLESSING_OF_SALVATION,
    },
    [HEALBOT_PRIEST] = {
      ["Left"] = HEALBOT_DISABLED_TARGET,
      ["ShiftLeft"] = HEALBOT_FOCUS,
      ["CtrlLeft"] = HEALBOT_ASSIST,
      ["AltLeft"] = HEALBOT_RESURRECTION,
      ["Right"] = HEALBOT_POWER_WORD_SHIELD,
      ["AltRight"] = HEALBOT_POWER_WORD_FORTITUDE,
      ["Middle"] = HEALBOT_RENEW,
      ["AltMiddle"] = HEALBOT_DIVINE_SPIRIT,
    },
    [HEALBOT_SHAMAN] = {
      ["Left"] = HEALBOT_DISABLED_TARGET,
      ["ShiftLeft"] = HEALBOT_FOCUS,
      ["CtrlLeft"] = HEALBOT_ASSIST,
      ["Right"] = HEALBOT_ANCESTRALSPIRIT,
    },
    [HEALBOT_HUNTER]   = {
      ["Left"] = HEALBOT_DISABLED_TARGET,
      ["ShiftLeft"] = HEALBOT_HEAVY_RUNECLOTH_BANDAGE,
      ["Right"] = HEALBOT_ASSIST,
      ["ShiftRight"] = HEALBOT_MAJOR_HEALING_POTION,
      },
    [HEALBOT_MAGE]     = {
      ["Left"] = HEALBOT_REMOVE_LESSER_CURSE,
      ["CtrlLeft"] = HEALBOT_DISABLED_TARGET,
      ["ShiftLeft"] = HEALBOT_HEAVY_RUNECLOTH_BANDAGE,
      ["Right"] = HEALBOT_ASSIST,
      ["ShiftRight"] = HEALBOT_MAJOR_HEALING_POTION,
      },
    [HEALBOT_ROGUE]    = {
      ["Left"] = HEALBOT_DISABLED_TARGET,
      ["ShiftLeft"] = HEALBOT_HEAVY_RUNECLOTH_BANDAGE,
      ["Right"] = HEALBOT_ASSIST,
      ["ShiftRight"] = HEALBOT_MAJOR_HEALING_POTION,
      },
    [HEALBOT_WARLOCK]  = {
      ["Left"] = HEALBOT_DISABLED_TARGET,
      ["ShiftLeft"] = HEALBOT_HEAVY_RUNECLOTH_BANDAGE,
      ["Right"] = HEALBOT_ASSIST,
      ["ShiftRight"] = HEALBOT_MAJOR_HEALING_POTION,
      },
    [HEALBOT_WARRIOR]  = {
      ["Left"] = HEALBOT_DISABLED_TARGET,
      ["ShiftLeft"] = HEALBOT_HEAVY_RUNECLOTH_BANDAGE,
      ["Right"] = HEALBOT_ASSIST,
      ["ShiftRight"] = HEALBOT_MAJOR_HEALING_POTION,
      },
  },
  EnableHealthy = 0,
  ActionVisible = 0,
  CDCLeftText = {[HEALBOT_PRIEST]="None", [HEALBOT_SHAMAN]="None", [HEALBOT_DRUID]="None", [HEALBOT_PALADIN]="None",},
  CDCRightText = {[HEALBOT_PRIEST]="None", [HEALBOT_SHAMAN]="None", [HEALBOT_DRUID]="None", [HEALBOT_PALADIN]="None",},
  Current_Skin = HEALBOT_SKINS_STD,
  Skin_ID = 1,
  Skins = {HEALBOT_SKINS_STD, "HealBot Party", "HealBot Raid", "Alteric Valley"},
  numcols = {[HEALBOT_SKINS_STD] = 1, ["HealBot Party"] = 1, ["HealBot Raid"] = 4, ["Alteric Valley"] = 2},
  btexture = {[HEALBOT_SKINS_STD] = 8,["HealBot Party"] = 6, ["HealBot Raid"] = 7, ["Alteric Valley"] = 9},
  bcspace = {[HEALBOT_SKINS_STD] = 4, ["HealBot Party"] = 4, ["HealBot Raid"] = 2, ["Alteric Valley"] = 2},
  brspace = {[HEALBOT_SKINS_STD] = 1, ["HealBot Party"] = 1, ["HealBot Raid"] = 2, ["Alteric Valley"] = 1},
  bwidth =  {[HEALBOT_SKINS_STD] = 122, ["HealBot Party"] = 115, ["HealBot Raid"] = 95, ["Alteric Valley"] = 85},
  bheight = {[HEALBOT_SKINS_STD] = 19, ["HealBot Party"] = 18, ["HealBot Raid"] = 17, ["Alteric Valley"] = 16},
  btextenabledcolr = {[HEALBOT_SKINS_STD] = 1, ["HealBot Party"] = 1, ["HealBot Raid"] = 1, ["Alteric Valley"] = 1},
  btextenabledcolg = {[HEALBOT_SKINS_STD] = 1, ["HealBot Party"] = 1, ["HealBot Raid"] = 1, ["Alteric Valley"] = 1},
  btextenabledcolb = {[HEALBOT_SKINS_STD] = 0, ["HealBot Party"] = 0, ["HealBot Raid"] = 0, ["Alteric Valley"] = 0},
  btextenabledcola = {[HEALBOT_SKINS_STD] = 1, ["HealBot Party"] = 1, ["HealBot Raid"] = 1, ["Alteric Valley"] = 1},
  btextdisbledcolr = {[HEALBOT_SKINS_STD] = 0.5, ["HealBot Party"] = 0.5, ["HealBot Raid"] = 0.5, ["Alteric Valley"] = 0.4},
  btextdisbledcolg = {[HEALBOT_SKINS_STD] = 0.5, ["HealBot Party"] = 0.5, ["HealBot Raid"] = 0.5, ["Alteric Valley"] = 0.4},
  btextdisbledcolb = {[HEALBOT_SKINS_STD] = 0.5, ["HealBot Party"] = 0.5, ["HealBot Raid"] = 0.5, ["Alteric Valley"] = 0.4},
  btextdisbledcola = {[HEALBOT_SKINS_STD] = 0.45, ["HealBot Party"] = 0.75, ["HealBot Raid"] = 0.75, ["Alteric Valley"] = 0},
  btextcursecolr = {[HEALBOT_SKINS_STD] = 1, ["HealBot Party"] = 1, ["HealBot Raid"] = 1, ["Alteric Valley"] = 1},
  btextcursecolg = {[HEALBOT_SKINS_STD] = 1, ["HealBot Party"] = 1, ["HealBot Raid"] = 1, ["Alteric Valley"] = 1},
  btextcursecolb = {[HEALBOT_SKINS_STD] = 1, ["HealBot Party"] = 1, ["HealBot Raid"] = 1, ["Alteric Valley"] = 1},
  btextcursecola = {[HEALBOT_SKINS_STD] = 1, ["HealBot Party"] = 1, ["HealBot Raid"] = 1, ["Alteric Valley"] = 1},
  backcola = {[HEALBOT_SKINS_STD] = 0.05, ["HealBot Party"] = 0.25, ["HealBot Raid"] = 0.25, ["Alteric Valley"] = 0},
  Barcola    = {[HEALBOT_SKINS_STD] = 0.85, ["HealBot Party"] = 0.85, ["HealBot Raid"] = 0.85, ["Alteric Valley"] = 0.85},
  BarcolaInHeal = {[HEALBOT_SKINS_STD] = 0.40, ["HealBot Party"] = 0.35, ["HealBot Raid"] = 0.35, ["Alteric Valley"] = 0.5},
  backcolr = {[HEALBOT_SKINS_STD] = 0.1, ["HealBot Party"] = 0.1, ["HealBot Raid"] = 0.1, ["Alteric Valley"] = 0.2},
  backcolg = {[HEALBOT_SKINS_STD] = 0.1, ["HealBot Party"] = 0.1, ["HealBot Raid"] = 0.1, ["Alteric Valley"] = 0.2},
  backcolb = {[HEALBOT_SKINS_STD] = 0.7, ["HealBot Party"] = 0.7, ["HealBot Raid"] = 0.7, ["Alteric Valley"] = 0.2},
  borcolr = {[HEALBOT_SKINS_STD] = 1, ["HealBot Party"] = 1, ["HealBot Raid"] = 1, ["Alteric Valley"] = 0.2},
  borcolg = {[HEALBOT_SKINS_STD] = 1, ["HealBot Party"] = 1, ["HealBot Raid"] = 1, ["Alteric Valley"] = 0.2},
  borcolb = {[HEALBOT_SKINS_STD] = 1, ["HealBot Party"] = 1, ["HealBot Raid"] = 1, ["Alteric Valley"] = 0.2},
  borcola = {[HEALBOT_SKINS_STD] = 0.25, ["HealBot Party"] = 0.8, ["HealBot Raid"] = 0.8, ["Alteric Valley"] = 0.1},
  btextheight = {[HEALBOT_SKINS_STD] = 10, ["HealBot Party"] = 10, ["HealBot Raid"] = 9, ["Alteric Valley"] = 10},
  bardisa = {[HEALBOT_SKINS_STD] = 0.15, ["HealBot Party"] = 0.75, ["HealBot Raid"] = 0.75, ["Alteric Valley"] = 0},
  bar2size = {[HEALBOT_SKINS_STD] = 4, ["HealBot Party"] = 4, ["HealBot Raid"] = 2, ["Alteric Valley"] = 2},
  ShowHeader = {[HEALBOT_SKINS_STD] = 0, ["HealBot Party"] = 0, ["HealBot Raid"] = 1, ["Alteric Valley"] = 0},
  headbarcolr = {[HEALBOT_SKINS_STD] = 0.3, ["HealBot Party"] = 0.1, ["HealBot Raid"] = 0.1, ["Alteric Valley"] = 0.1},
  headbarcolg = {[HEALBOT_SKINS_STD] = 0.3, ["HealBot Party"] = 0.1, ["HealBot Raid"] = 0.1, ["Alteric Valley"] = 0.1},
  headbarcolb = {[HEALBOT_SKINS_STD] = 0.5, ["HealBot Party"] = 0.1, ["HealBot Raid"] = 0.1, ["Alteric Valley"] = 0.1},
  headbarcola = {[HEALBOT_SKINS_STD] = 0.35, ["HealBot Party"] = 0.25, ["HealBot Raid"] = 0.25, ["Alteric Valley"] = 0},
  headtxtcolr = {[HEALBOT_SKINS_STD] = 0.9, ["HealBot Party"] = 1, ["HealBot Raid"] = 1, ["Alteric Valley"] = 1},
  headtxtcolg = {[HEALBOT_SKINS_STD] = 0.9, ["HealBot Party"] = 1, ["HealBot Raid"] = 1, ["Alteric Valley"] = 1},
  headtxtcolb = {[HEALBOT_SKINS_STD] = 0.4, ["HealBot Party"] = 0.1, ["HealBot Raid"] = 0.1, ["Alteric Valley"] = 0.1},
  headtxtcola = {[HEALBOT_SKINS_STD] = 1, ["HealBot Party"] = 1, ["HealBot Raid"] = 1, ["Alteric Valley"] = 1},
  headtexture = {[HEALBOT_SKINS_STD] = 6, ["HealBot Party"] = 11, ["HealBot Raid"] = 12, ["Alteric Valley"] = 12},
  headwidth   = {[HEALBOT_SKINS_STD] = 0.65, ["HealBot Party"] = 0.9, ["HealBot Raid"] = 0.9, ["Alteric Valley"] = 0.9},
  Tooltip_ShowSpellDetail = 0,
  Tooltip_ShowTarget = 1,
  TooltipPos = 1,  
  ExtraIncGroup = {[1] = true, [2] = true, [3] = true, [4] = true, 
                   [5] = true, [6] = true, [7] = true, [8] = true},
   
  BuffText = {
    [HEALBOT_DRUID] = {
              [1] = "",
              [2] = "",
              [3] = "", [4] = "",
              [5] = "", [6] = "",
              [7] = "", [8] = "",
              [9] = ""},
    [HEALBOT_PALADIN] = {
              [1] = "", [2] = "", 
              [3] = "", [4] = "",
              [5] = "", [6] = "",
              [7] = "", [8] = "",
              [9] = ""},
    [HEALBOT_PRIEST] = {
              [1] = "",
              [2] = "",
              [3] = "", [4] = "",
              [5] = "", [6] = "",
              [7] = "", [8] = "",
              [9] = ""},
    [HEALBOT_SHAMAN] = {
              [1] = "", [2] = "", 
              [3] = "", [4] = "",
              [5] = "", [6] = "",
              [7] = "", [8] = "",
              [9] = ""},
    [HEALBOT_HUNTER] = {
              [1] = "", [2] = "", 
              [3] = "", [4] = "",
              [5] = "", [6] = "",
              [7] = "", [8] = "",
              [9] = ""},
    [HEALBOT_MAGE] = {
              [1] = "", [2] = "", 
              [3] = "", [4] = "",
              [5] = "", [6] = "",
              [7] = "", [8] = "",
              [9] = ""},
    [HEALBOT_ROGUE] = {
              [1] = "", [2] = "", 
              [3] = "", [4] = "",
              [5] = "", [6] = "",
              [7] = "", [8] = "",
              [9] = ""},
    [HEALBOT_WARLOCK] = {
              [1] = "", [2] = "", 
              [3] = "", [4] = "",
              [5] = "", [6] = "",
              [7] = "", [8] = "",
              [9] = ""},
    [HEALBOT_WARRIOR] = {
              [1] = "", [2] = "", 
              [3] = "", [4] = "",
              [5] = "", [6] = "",
              [7] = "", [8] = "",
              [9] = ""},
  },
  DebuffText = {
    [HEALBOT_DRUID] = {[1] = "", [2] = "", [3] = "",},
    [HEALBOT_PALADIN] = {[1] = "", [2] = "", [3] = "",},
    [HEALBOT_PRIEST] = {[1] = "", [2] = "", [3] = "",},
    [HEALBOT_SHAMAN] = {[1] = "", [2] = "", [3] = "",},
    [HEALBOT_HUNTER] = {[1] = "", [2] = "", [3] = "",},
    [HEALBOT_MAGE] = {[1] = "", [2] = "", [3] = "",},
    [HEALBOT_ROGUE] = {[1] = "", [2] = "", [3] = "",},
    [HEALBOT_WARLOCK] = {[1] = "", [2] = "", [3] = "",},
    [HEALBOT_WARRIOR] = {[1] = "", [2] = "", [3] = "",},
  },
  BuffDropDown = {
    [HEALBOT_DRUID] = {   [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_PALADIN] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_PRIEST] = {  [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_SHAMAN] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_HUNTER] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_MAGE] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_ROGUE] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_WARLOCK] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_WARRIOR] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
  },
  DebuffDropDown = {
    [HEALBOT_DRUID] = {   [1] = 1, [2] = 1, [3] = 1,},
    [HEALBOT_PALADIN] = { [1] = 1, [2] = 1, [3] = 1,},
    [HEALBOT_PRIEST] = {  [1] = 1, [2] = 1, [3] = 1,},
    [HEALBOT_SHAMAN] = { [1] = 1, [2] = 1, [3] = 1,},
    [HEALBOT_HUNTER] = { [1] = 1, [2] = 1, [3] = 1,},
    [HEALBOT_MAGE] = { [1] = 1, [2] = 1, [3] = 1,},
    [HEALBOT_ROGUE] = { [1] = 1, [2] = 1, [3] = 1,},
    [HEALBOT_WARLOCK] = { [1] = 1, [2] = 1, [3] = 1,},
    [HEALBOT_WARRIOR] = { [1] = 1, [2] = 1, [3] = 1,},
  },
  BuffSpellDropDown = {
    [HEALBOT_DRUID] = {   [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_PALADIN] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_PRIEST] = {  [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_SHAMAN] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_HUNTER] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_MAGE] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_ROGUE] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_WARLOCK] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_WARRIOR] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
  },
  DebuffSpellDropDown = {
    [HEALBOT_DRUID] = {   [1] = 1, [2] = 1, [3] = 1,},
    [HEALBOT_PALADIN] = { [1] = 1, [2] = 1, [3] = 1,},
    [HEALBOT_PRIEST] = {  [1] = 1, [2] = 1, [3] = 1,},
    [HEALBOT_SHAMAN] = {  [1] = 1, [2] = 1, [3] = 1,},
    [HEALBOT_HUNTER] = {  [1] = 1, [2] = 1, [3] = 1,},
    [HEALBOT_MAGE] = {  [1] = 1, [2] = 1, [3] = 1,},
    [HEALBOT_ROGUE] = {  [1] = 1, [2] = 1, [3] = 1,},
    [HEALBOT_WARLOCK] = {  [1] = 1, [2] = 1, [3] = 1,},
    [HEALBOT_WARRIOR] = {  [1] = 1, [2] = 1, [3] = 1,},
  },
  buffbarcolr = {
    [HEALBOT_DRUID] = {   [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_PALADIN] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_PRIEST] = {  [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_SHAMAN] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_HUNTER] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_MAGE] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_ROGUE] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_WARLOCK] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_WARRIOR] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
  },
  buffbarcolg = {
    [HEALBOT_DRUID] = {   [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_PALADIN] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_PRIEST] = {  [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_SHAMAN] = {  [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_HUNTER] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_MAGE] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_ROGUE] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_WARLOCK] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_WARRIOR] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
  },
  buffbarcolb = {
    [HEALBOT_DRUID] = {   [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_PALADIN] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_PRIEST] = {  [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_SHAMAN] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_HUNTER] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_MAGE] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_ROGUE] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_WARLOCK] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
    [HEALBOT_WARRIOR] = { [1] = 1, [2] = 1, 
                          [3] = 1, [4] = 1,
                          [5] = 1, [6] = 1,
                          [7] = 1, [8] = 1,
                          [9] = 1},
  },
};
	
HealBot_Config = {};

HealBot_HealsIn = {};
HealBot_Healers = {};
HealBot_UnitDebuff = {};
HealBot_UnitBuff = {};

HealBot_ResetHealsInFlag=true;

HEALBOT_ADDON_ID="HealBot_Heals"

HealBot_OtherSpells = {};

HealBot_Spells = {};

HealBot_Debuff_Spells = {
  [HEALBOT_PALADIN] = {
    HEALBOT_PURIFY,
    HEALBOT_CLEANSE,
                      },
  [HEALBOT_DRUID] = {
    HEALBOT_CURE_POISON,
    HEALBOT_REMOVE_CURSE,
    HEALBOT_ABOLISH_POISON,
                    },
  [HEALBOT_PRIEST] = {
    HEALBOT_CURE_DISEASE,
    HEALBOT_DISPEL_MAGIC,
    HEALBOT_ABOLISH_DISEASE,
                     },
  [HEALBOT_SHAMAN] = {
    HEALBOT_CURE_POISON,
    HEALBOT_CURE_DISEASE,
                       },
  [HEALBOT_HUNTER] = {},
  [HEALBOT_MAGE] = {HEALBOT_REMOVE_LESSER_CURSE,},
  [HEALBOT_ROGUE] = {},
  [HEALBOT_WARLOCK] = {},
  [HEALBOT_WARRIOR] = {},
}

HealBot_Debuff_Types = {
  [HEALBOT_PURIFY] = {HEALBOT_DISEASE_en, HEALBOT_POISON_en},
  [HEALBOT_CLEANSE] = {HEALBOT_DISEASE_en, HEALBOT_POISON_en, HEALBOT_MAGIC_en},
  [HEALBOT_CURE_POISON] = {HEALBOT_POISON_en},
  [HEALBOT_REMOVE_CURSE] = {HEALBOT_CURSE_en},
  [HEALBOT_ABOLISH_POISON] = {HEALBOT_POISON_en},
  [HEALBOT_CURE_DISEASE] = {HEALBOT_DISEASE_en},
  [HEALBOT_ABOLISH_DISEASE] = {HEALBOT_DISEASE_en},
  [HEALBOT_DISPEL_MAGIC..HEALBOT_RANK_1] = {HEALBOT_MAGIC_en},
  [HEALBOT_DISPEL_MAGIC..HEALBOT_RANK_2] = {HEALBOT_MAGIC_en},  
  [HEALBOT_REMOVE_LESSER_CURSE] = {HEALBOT_CURSE_en},
  [HEALBOT_PURIFICATION_POTION] = {HEALBOT_CURSE_en, HEALBOT_DISEASE_en, HEALBOT_POISON_en},
  [HEALBOT_ANTI_VENOM] = {HEALBOT_POISON_en},
  [HEALBOT_POWERFUL_ANTI_VENOM] = {HEALBOT_POISON_en},
  [HEALBOT_ELIXIR_OF_POISON_RES] = {HEALBOT_POISON_en},
}

HealBot_Ignore_Class_Debuffs = {
    [HEALBOT_WARRIOR] = { [HEALBOT_DEBUFF_ANCIENT_HYSTERIA] = true,	
                          [HEALBOT_DEBUFF_IGNITE_MANA] = true, 
                          [HEALBOT_DEBUFF_TAINTED_MIND] = true, 
                          [HEALBOT_DEBUFF_VIPER_STING] = true,
                          [HEALBOT_DEBUFF_IMPOTENCE] = true,
                          [HEALBOT_DEBUFF_DECAYED_INT] = true,
                          [HEALBOT_DEBUFF_UNSTABLE_AFFL] = true,},
    [HEALBOT_ROGUE] = {   [HEALBOT_DEBUFF_SILENCE] = true,	
                          [HEALBOT_DEBUFF_ANCIENT_HYSTERIA] = true, 
                          [HEALBOT_DEBUFF_IGNITE_MANA] = true, 
                          [HEALBOT_DEBUFF_TAINTED_MIND] = true, 
                          [HEALBOT_DEBUFF_VIPER_STING] = true,
                          [HEALBOT_DEBUFF_IMPOTENCE] = true,
                          [HEALBOT_DEBUFF_DECAYED_INT] = true,
                          [HEALBOT_DEBUFF_UNSTABLE_AFFL] = true,},
    [HEALBOT_HUNTER] = {  [HEALBOT_DEBUFF_MAGMA_SHACKLES] = true, 
                          [HEALBOT_DEBUFF_UNSTABLE_AFFL] = true,},
    [HEALBOT_MAGE] = {    [HEALBOT_DEBUFF_MAGMA_SHACKLES] = true, 
                          [HEALBOT_DEBUFF_DECAYED_STR] = true,
                          [HEALBOT_DEBUFF_CRIPPLE] = true,
                          [HEALBOT_DEBUFF_UNSTABLE_AFFL] = true,},
    [HEALBOT_DRUID] = {   [HEALBOT_DEBUFF_UNSTABLE_AFFL] = true,},
    [HEALBOT_PALADIN] = { [HEALBOT_DEBUFF_UNSTABLE_AFFL] = true,},
    [HEALBOT_PRIEST] = {  [HEALBOT_DEBUFF_DECAYED_STR] = true,
                          [HEALBOT_DEBUFF_CRIPPLE] = true,
                          [HEALBOT_DEBUFF_UNSTABLE_AFFL] = true,},
    [HEALBOT_SHAMAN] = {  [HEALBOT_DEBUFF_UNSTABLE_AFFL] = true,},
    [HEALBOT_WARLOCK] = { [HEALBOT_DEBUFF_DECAYED_STR] = true,
                          [HEALBOT_DEBUFF_CRIPPLE] = true,
                          [HEALBOT_DEBUFF_UNSTABLE_AFFL] = true,},
};

HealBot_Ignore_Movement_Debuffs = {
                                  [HEALBOT_DEBUFF_FROSTBOLT] = true,
                                  [HEALBOT_DEBUFF_MAGMA_SHACKLES] = true,
                                  [HEALBOT_DEBUFF_SLOW] = true,
                                  [HEALBOT_DEBUFF_CHILLED] = true,
                                  [HEALBOT_DEBUFF_CONEOFCOLD] = true,
                                  [HEALBOT_DEBUFF_CONCUSSIVESHOT] = true,
                                  [HEALBOT_DEBUFF_THUNDERCLAP] = true,
                                  [HEALBOT_DEBUFF_HOWLINGSCREECH] = true,
                                  [HEALBOT_DEBUFF_DAZED] = true,
};

HealBot_Ignore_FastDur_Debuffs = {
                                  [HEALBOT_DEBUFF_PSYCHIC_HORROR] = true,
                                  [HEALBOT_DEBUFF_CHILLED] = true,
                                  [HEALBOT_DEBUFF_CONEOFCOLD] = true,
                                  [HEALBOT_DEBUFF_CONCUSSIVESHOT] = true,
                                  [HEALBOT_DEBUFF_FALTER] = true,
};

HealBot_Ignore_NonHarmful_Debuffs = {
                                  [HEALBOT_DEBUFF_HUNTERS_MARK] = true,
                                  [HEALBOT_DEBUFF_ARCANE_BLAST] = true,
};

HealBot_DebuffSpell = {};

HealBot_IsFighting = false;

HealBot_DebuffPriority="none";
HealBot_DebuffWatchTarget = {};

HealBot_BuffWatch = {};
HealBot_BuffWatchTarget = {};
HealBot_buffbarcolr = {};
HealBot_buffbarcolg = {};
HealBot_buffbarcolb = {};

HealBot_CurrentSpells = {};

HealBot_EmergInc = {};
HealBot_Skins = {};
HealBot_ErrorCnt=0;
HealBot_SpamCnt=0;
HealBot_Action_TooltipUnit=nil;
HealBot_Ressing = {};
Delay_RecalcParty=0;
HealBot_MainTanks={};
SmartCast_Heal={}
SmartCast_Res=nil;
HealBot_DelayBuffCheck = {};
HealBot_DelayDebuffCheck = {};
HealBot_DelayData=1;
HealBot_PlayerCanCast=true;
HealBot_PlayerClass=nil;
HealBot_PlayerClassEN=nil;
HealBot_UnitName = {};
HealBot_UnitID = {};
HealBot_UnitClass = {};
HealBot_UnitLevel = {};
HealBot_HealingBonus=0;
HealBot_PlayerName=nil;
HealBot_CastingTarget = nil;
HealBot_InnerFocus=false;
HealBot_Unit_Button={};
HealBot_HoT_Texture={};
HealBot_HoT_Texture[HEALBOT_REJUVENATION]      = "Interface\\Icons\\Spell_Nature_Rejuvenation";
HealBot_HoT_Texture[HEALBOT_REGROWTH]          = "Interface\\Icons\\Spell_Nature_ResistNature";
HealBot_HoT_Texture[HEALBOT_LIFEBLOOM]          = "Interface\\Icons\\INV_Misc_Herb_Felblossom.jpg";
HealBot_HoT_Texture[HEALBOT_RENEW]             = "Interface\\Icons\\Spell_Holy_Renew";
HealBot_HoT_Texture[HEALBOT_POWER_WORD_SHIELD] = "Interface\\Icons\\Spell_Holy_PowerWordShield";
HealBot_HoT_Texture[HEALBOT_PRAYER_OF_MENDING] = "Interface\\Icons\\Spell_Holy_PrayerOfMendingtga.jpg";
