--
-- ZubanLib Library Functions
-- Author: Zuban (chumpnet@hotmail.com)
--

-- 
-- class Const
-- See localization.lua for some translations.
--

ZubanLib.Const = {
	-- returned by ZubanLib.Unit:PowerType()
	PowerType = {
		[0] = "mana";
		[1] = "rage ";
		[2] = "focus";
		[3] = "energy";
		[4] = "happiness";
	};
	
	-- returned by ZubanLib.Unit:Sex()
	Sex = {
		[0] = "male";
		[1] = "female";
		[2] = "unknown";
	};
	
	UnitID = {
		Player = "player";
		Pet = "pet";
		Target = "target";
		MouseOver = "mouseover";
		Npc = "npc";
	};

	LocalizedClass = {
		Druid = "Druid";
		Hunter = "Hunter";
		Mage = "Mage";
		Paladin = "Paladin";
		Priest = "Priest";
		Rogue = "Rogue";
		Shaman = "Shaman";
		Warlock = "Warlock";
		Warrior = "Warrior";
	};
	
	Class = {
		Druid = "DRUID";
		Hunter = "HUNTER";
		Mage = "MAGE";
		Paladin = "PALADIN";
		Priest = "PRIEST";
		Rogue = "ROGUE";
		Shaman = "SHAMAN";
		Warlock = "WARLOCK";
		Warrior = "WARRIOR";
	};
	
	-- passed into ZubanLib.Unit:Resistance(resistanceIndex)
	Resistance = {
		ArmorRating = 0;
		Unknown = 1;
		Fire = 2;
		Nature = 3;
		Frost = 4;
		Shadow = 5;
		Arcane = 6;
	};
	
	-- passed into ZubanLib.Unit:Stat(statIndex)
	Stat = {
		Strength = 1;
		Agility = 2;
		Stamina = 3;
		Intellect = 4;
		Spirit = 5;
	};
	
	Classification = {
		WorldBoss = "worldboss";
		RareElite = "rareelite";
		Elite = "elite";
		Rare = "rare";
		Normal = "normal";
	};
};

ZubanLib.Const.Realm = GetCVar("RealmName");

function ZubanLib.Const.UnitID.Raid(i)
	return "raid"..i;
end

function ZubanLib.Const.UnitID.Party(i)
	return "party"..i;
end
