-- **************************************************************************
-- * TitanShardCounter.lua
-- * This addon will display current count of shards on Titan Bar.
-- * Use of ShardCount for help in determining shard count.
-- * 
-- * Version History(v.11)
-- * 1) First version of TitanShardCounter
-- *************************************************************************

-- ************************************* Const / defines *************************************
TITAN_SHARDCOUNTER_ID = "ShardCounter";
TITAN_SHARDCOUNTER_COUNT_FORMAT = "%d";
TITAN_SHARDCOUNTER_MENU_TEXT = "ShardCounter";
TITAN_SHARDCOUNTER_BUTTON_LABEL = "Shards: ";
TITAN_SHARDCOUNTER_TOOLTIP = "ShardCounter Tooltip";
TITAN_SHARDCOUNTER_TOOLTIP_COUNT = "Shards: ";
TITAN_SHARDCOUNTER_ICON = "Interface\\Addons\\Titan\\TitanShardCounter\\Artwork\\TitanShard";

-- ************************************* Variables *******************************************
numShards = 0;

-- ************************************* Functions *******************************************
-- *******************************************************************************************
-- Name: TitanPanelShardCounterButton_OnLoad
-- Desc: This function registers ShardCounter Addon.
-- *******************************************************************************************
function TitanPanelShardCounterButton_OnLoad()
	this.registry = { 
		id = TITAN_SHARDCOUNTER_ID,
		menuText = TITAN_SHARDCOUNTER_MENU_TEXT, 
		buttonTextFunction = "TitanPanelShardCounterButton_GetButtonText", 
		tooltipTitle = TITAN_SHARDCOUTER_TOOLTIP,
		tooltipTextFunction = "TitanPanelShardCounterButton_GetTooltipText",
		icon = TITAN_SHARDCOUNTER_ICON,	
		iconWidth = 16,
		savedVariables = {
			ShowLabelText = 1,  -- Default to 1
			ShowIcon = 1
		}
	};
	this:RegisterEvent("BAG_UPDATE");
	this:RegisterEvent("UNIT_INVENTORY_CHANGED");
	this:RegisterEvent("PLAYER_ENTERING_WORLD");
end

-- *******************************************************************************************
-- Name: TitanPanelShardCounterButton_OnUpdate
-- Desc: Retrieves shard count anytime an update occurs with bag/unit/player events and updates
--	 Titan button accordingly.
-- *******************************************************************************************
function TitanPanelShardCounterButton_OnUpdate(arg1)
	numShards = ShardCounter_CountShards();
	TitanPanelButton_UpdateButton(TITAN_SHARDCOUNTER_ID);
end

-- *******************************************************************************************
-- Name: TitanPanelShardCounterButton_GetButtonText
-- Desc: Gets our button text, the text that appears on the actual bar, all the time.
-- *******************************************************************************************
function TitanPanelShardCounterButton_GetButtonText(id)
	-- If id not nil, return corresponding plugin button
	-- Otherwise return this button and derive the real id
	local button, id = TitanUtils_GetButton(id, true);
	
	-- Business logic goes here
	numShards = ShardCounter_CountShards();
	
	local countText = format(TITAN_SHARDCOUNTER_COUNT_FORMAT, numShards);
	return TITAN_SHARDCOUNTER_BUTTON_LABEL.."\t"..TitanUtils_GetHighlightText(countText);
end

-- *******************************************************************************************
-- Name: TitanPanelShardCounterButton_GetTooltipText
-- Desc: Gets our tool-tip text, what appears when we hover over our item on the Titan bar.
-- *******************************************************************************************
function TitanPanelShardCounterButton_GetTooltipText()
	return "Current Shard Count";
end

-- *******************************************************************************************
-- Name: ShardCounter_CountShards
-- Desc: Counts number of shards currently in player's bag.
-- *******************************************************************************************
function ShardCounter_CountShards()   
	local shards = 0;   
	local bag, slot = 0;
	for bag = 0, NUM_BAG_FRAMES do      
		for slot = 1, GetContainerNumSlots(bag) do         
		local itemName = GetContainerItemLink(bag, slot);        
			if itemName then             
				if string.find(itemName, "%[Soul Shard%]") then           
				shards = shards + 1;
				end        
			end  
		end
	end
	return shards;
end