--[[

Jubei's LinkToolTip version 0.5
by Keith Batten <keith.batten@gmail.com>

Created: March 22, 2005
Last Updated: December 5, 2006


About:	Add a tooltip to chat links
History:
 v0.5 - Udpated for patch 2.0
 v0.4 - No longer needs ChatFrame.xml :)
 v0.3 - Made it compatible with UI1500
 v0.2 - Added slash commands to enable/disable
	Added slash commands to set tooltip to mouse position or default
 v0.1 - First release

Caveats:

Todo:

Bugs:

]]


JUBEI_LINKTOOLTIP_VERSION = "0.5";

----------- INIT VARIABLES -----------

local Jubei_LinkToolTip_Loaded = false;
local Jubei_LinkToolTip_Loaded_Vars = false;
local Jubei_LinkToolTip_Loaded_PlayerName = false;
local Jubei_LinkToolTip_OnHyperlinkEnter_Table = { };
local Jubei_LinkToolTip_OnHyperlinkLeave_Table = { };
Jubei_LinkToolTip_Config = { };

----------- MOD VARIABLES -----------

local Jubei_LinkToolTip_PlayerName = nil;
local Jubei_LinkToolTip_WhoPlayerName = nil;

----------- OBJECTS -----------

local Jubei_LinkToolTip_SlashCmd = nil;

----------- CONSTANTS -----------

local JUBEI_LINKTOOLTIP_MOUSE = 0;
local JUBEI_LINKTOOLTIP_DEFAULT = 1;
local JUBEI_LINKTOOLTIP_VERBOSITY = 0;		-- the higher the verbosity level of a debug print, the lower priority

-----------------------------------------------------------------------------


function Jubei_LinkToolTip_OnLoad()
	if ( DEFAULT_CHAT_FRAME ) then
		DEFAULT_CHAT_FRAME:AddMessage("Jubei's LinkToolTip AddOn loaded", 1.0, 1.0, 1.0);
	end

	this:RegisterEvent("VARIABLES_LOADED");
end

function Jubei_LinkToolTip_OnEvent(event)
	if (Jubei_LinkToolTip_Loaded_Vars == false) then
		if (event == "VARIABLES_LOADED") then
			Jubei_LinkToolTip_Loaded_Vars = true;
			Jubei_LinkToolTip_Init();
		end
	end

	if (Jubei_LinkToolTip_Loaded_PlayerName == false) then
		local PlayerName = UnitName("player");
		if ((PlayerName) and (PlayerName ~= "Unknown Entity")) then
			Jubei_LinkToolTip_PlayerName = string.lower(PlayerName);
			Jubei_LinkToolTip_Loaded_PlayerName = true;
			Jubei_LinkToolTip_Init();
		end
	end
end


function Jubei_LinkToolTip_Init()
	if not ((Jubei_LinkToolTip_Loaded_Vars) and (Jubei_LinkToolTip_Loaded_PlayerName)) then
		return;
	end

	if (Jubei_LinkToolTip_Config[Jubei_LinkToolTip_PlayerName] == nil) then
		Jubei_LinkToolTip_Config[Jubei_LinkToolTip_PlayerName] = { };
		Jubei_LinkToolTip_Config[Jubei_LinkToolTip_PlayerName]["position"] = JUBEI_LINKTOOLTIP_MOUSE;
		Jubei_LinkToolTip_Config[Jubei_LinkToolTip_PlayerName]["enabled"] = true;
	end

	Jubei_LinkToolTip_Loaded = true;

-- SlashCommands
	Jubei_LinkToolTip_SlashCmd = JCSlashCmd:new("ltt");
	Jubei_LinkToolTip_SlashCmd:addAlias("linktooltip");

	Jubei_LinkToolTip_SlashCmd:setHelpTitle("Jubei's LinkToolTip Usage: ");
	Jubei_LinkToolTip_SlashCmd:setHelpColor(1.0, 0.5, 0.25);
	Jubei_LinkToolTip_SlashCmd:setHelpVersion("Jubei's LinkToolTip Addon "..JUBEI_LINKTOOLTIP_VERSION..", contact <keith.batten@gmail.com>");

	Jubei_LinkToolTip_SlashCmd:addCmd("mouse",0," - Set the tooltip at the mouse",Jubei_LinkToolTip_CmdMouse);
	Jubei_LinkToolTip_SlashCmd:addCmd("default",0," - Set the tooltip at the default tooltip position",Jubei_LinkToolTip_CmdDefault);
	Jubei_LinkToolTip_SlashCmd:addCmd("enable",0," - Enable the mod",Jubei_LinkToolTip_CmdEnable);
	Jubei_LinkToolTip_SlashCmd:addCmd("disable",0," - Disable the mod",Jubei_LinkToolTip_CmdDisable);

-- Hook the original function
--	Jubei_LinkToolTip_ChatFrame_OnHyperlinkHide_Original = ChatFrame_OnHyperlinkHide;
--	ChatFrame_OnHyperlinkHide = Jubei_LinkToolTip_ChatFrame_OnHyperlinkHide;


--			<OnHyperlinkEnter>
--				Jubei_LinkToolTip_ChatFrame_OnHyperlinkEnter(arg1,arg2);
--			</OnHyperlinkEnter>
--
--			<OnHyperlinkLeave>
--				Jubei_LinkToolTip_ChatFrame_OnHyperlinkHide();
--			</OnHyperlinkLeave>
	local i=1;

	while getglobal("ChatFrame"..i) do
		Jubei_LinkToolTip_OnHyperlinkEnter_Table["ChatFrame"..i] = getglobal("ChatFrame"..i):GetScript("OnHyperlinkEnter");
		Jubei_LinkToolTip_OnHyperlinkLeave_Table["ChatFrame"..i] = getglobal("ChatFrame"..i):GetScript("OnHyperlinkLeave");
		getglobal("ChatFrame"..i):SetScript("OnHyperlinkEnter", Jubei_LinkToolTip_ChatFrame_OnHyperlinkEnter);
		getglobal("ChatFrame"..i):SetScript("OnHyperlinkLeave", Jubei_LinkToolTip_ChatFrame_OnHyperlinkHide);
		i = i+1;
	end
end


-----------------------------------------------------------------------------


function Jubei_LinkToolTip_CmdMouse()
	Jubei_LinkToolTip_Config[Jubei_LinkToolTip_PlayerName]["position"] = JUBEI_LINKTOOLTIP_MOUSE;
end

function Jubei_LinkToolTip_CmdDefault()
	Jubei_LinkToolTip_Config[Jubei_LinkToolTip_PlayerName]["position"] = JUBEI_LINKTOOLTIP_DEFAULT;
end

function Jubei_LinkToolTip_CmdEnable()
	Jubei_LinkToolTip_Config[Jubei_LinkToolTip_PlayerName]["enabled"] = true;
end

function Jubei_LinkToolTip_CmdDisable()
	Jubei_LinkToolTip_Config[Jubei_LinkToolTip_PlayerName]["enabled"] = false;
end


-----------------------------------------------------------------------------


function Jubei_LinkToolTop_SetAnchor()
	if not (Jubei_LinkToolTip_Config[Jubei_LinkToolTip_PlayerName]["enabled"]) then return end

	if (Jubei_LinkToolTip_Config[Jubei_LinkToolTip_PlayerName]["position"] == JUBEI_LINKTOOLTIP_MOUSE) then
		GameTooltip:SetOwner(UIParent, "ANCHOR_CURSOR");
	else
		GameTooltip_SetDefaultAnchor(GameTooltip, UIParent);
	end
end

-- called on enter
function Jubei_LinkToolTip_ChatFrame_OnHyperlinkEnter()
	if (Jubei_LinkToolTip_OnHyperlinkEnter_Table[this:GetName()]) then
		Jubei_LinkToolTip_OnHyperlinkEnter_Table[this:GetName()]();
	end

	local link = arg1;
	local button = arg2;

	if not (Jubei_LinkToolTip_Config[Jubei_LinkToolTip_PlayerName]["enabled"]) then return end

	if ( strsub(link, 1, 6) ~= "player" ) then
		ShowUIPanel(GameTooltip);
		Jubei_LinkToolTop_SetAnchor();
		GameTooltip:SetHyperlink(link);
	end
end


-- called on leave
function Jubei_LinkToolTip_ChatFrame_OnHyperlinkHide()
	if (Jubei_LinkToolTip_OnHyperlinkLeave_Table[this:GetName()]) then
		Jubei_LinkToolTip_OnHyperlinkLeave_Table[this:GetName()]();
	end

	if not (Jubei_LinkToolTip_Config[Jubei_LinkToolTip_PlayerName]["enabled"]) then return end

	HideUIPanel(GameTooltip);
end